// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: LineoutViewerEnginePluginInfo.C
// ****************************************************************************

#include <LineoutPluginInfo.h>
#include <LineoutAttributes.h>

//
// Storage for static data elements.
//
LineoutAttributes *LineoutViewerEnginePluginInfo::clientAtts = NULL;
LineoutAttributes *LineoutViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  LineoutViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
LineoutViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (LineoutViewerEnginePluginInfo::clientAtts == NULL)
    {
        LineoutViewerEnginePluginInfo::clientAtts  = new LineoutAttributes;
        LineoutViewerEnginePluginInfo::defaultAtts = new LineoutAttributes;
    }
}

// ****************************************************************************
//  Method: LineoutViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
LineoutViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: LineoutViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
LineoutViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: LineoutViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LineoutViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(LineoutAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: LineoutViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LineoutViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(LineoutAttributes *)atts = *clientAtts;
}

bool
LineoutViewerEnginePluginInfo::Removeable() const
{
    return false;
}

bool
LineoutViewerEnginePluginInfo::Moveable() const
{
    return false;
}

bool
LineoutViewerEnginePluginInfo::AllowsSubsequentOperators() const
{
    return false;
}

// ****************************************************************************
//  Method: LineoutViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LineoutViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(LineoutAttributes*)atts = *defaultAtts;
    else
        *(LineoutAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: LineoutViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LineoutViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: LineoutViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
LineoutViewerEnginePluginInfo::GetMenuName() const
{
    return "Lineout";
}

