// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  LineSurfaceScriptingPluginInfo.C
// ************************************************************************* //
#include <PyLineSurfaceAttributes.h>
#include <LineSurfacePluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(LineSurface,Scripting)

// ****************************************************************************
// Method: LineSurfaceScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
LineSurfaceScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyLineSurfaceAttributes_StartUp((LineSurfaceAttributes *)subj, data);
}

// ****************************************************************************
// Method: LineSurfaceScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
LineSurfaceScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyLineSurfaceAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: LineSurfaceScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is LineSurface plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
LineSurfaceScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyLineSurfaceAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: LineSurfaceScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
LineSurfaceScriptingPluginInfo::GetLogString()
{
    std::string s(PyLineSurfaceAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: LineSurfaceScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
LineSurfaceScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyLineSurfaceAttributes_SetDefaults((const LineSurfaceAttributes *)atts);
}
