// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: LineSurfacePluginInfo.h
// ****************************************************************************

#ifndef LINESURFACE_PLUGIN_INFO_H
#define LINESURFACE_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class LineSurfaceAttributes;

// ****************************************************************************
//  Class: LineSurfacePluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an LineSurface operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class LineSurfaceGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class LineSurfaceCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual LineSurfaceGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class LineSurfaceGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual LineSurfaceCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class LineSurfaceViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual LineSurfaceCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static LineSurfaceAttributes *defaultAtts;
    static LineSurfaceAttributes *clientAtts;
};

class LineSurfaceViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual LineSurfaceViewerEnginePluginInfo
{
  public:
};

class LineSurfaceEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual LineSurfaceViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class LineSurfaceScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual LineSurfaceCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
