// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: LineSurfaceCommonPluginInfo.C
// ****************************************************************************

#include <LineSurfacePluginInfo.h>
#include <LineSurfaceAttributes.h>

// ****************************************************************************
//  Method: LineSurfaceCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
LineSurfaceCommonPluginInfo::AllocAttributes()
{
    return new LineSurfaceAttributes;
}

// ****************************************************************************
//  Method: LineSurfaceCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a LineSurface attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LineSurfaceCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((LineSurfaceAttributes *) to) = *((LineSurfaceAttributes *) from);
}
