// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtLineSamplerFilter.h
// ************************************************************************* //

#ifndef AVT_LineSampler_FILTER_H
#define AVT_LineSampler_FILTER_H


//#include <avtPluginDataTreeIterator.h>
#include <avtPluginFilter.h>
#include <avtTimeLoopFilter.h>
#include <avtDatasetToDatasetFilter.h>

#include <avtVector.h>
#include <avtExtents.h>

#include <LineSamplerAttributes.h>

class vtkTransform;
class vtkDataSet;
class vtkPolyData;
class vtkUnstructuredGrid;


// ****************************************************************************
//  Class: avtLineSamplerFilter
//
//  Purpose:
//      A plugin operator for LineSampler.
//
//  Programmer: allen -- generated by xml2avt
//  Creation:   Thu Oct 14 15:05:33 PST 2010
//
// ****************************************************************************

class avtLineSamplerFilter : virtual public avtPluginFilter,
                             virtual public avtTimeLoopFilter,
                             virtual public avtDatasetToDatasetFilter
{
  public:
                         avtLineSamplerFilter();
    virtual             ~avtLineSamplerFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtLineSamplerFilter"; };
    virtual const char  *GetDescription(void)
                             { return "LineSampler"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    LineSamplerAttributes atts;

    virtual void InitializeTimeLoop(void);

    virtual void ExamineContract(avtContract_p in_contract);
    virtual void Execute(void);
    virtual void CreateFinalOutput(void);
    virtual bool ExecutionSuccessful(void);

    virtual vtkDataSet* ExecuteChannelData(vtkDataSet *, int, std::string);
//  virtual vtkDataSet* ExecuteChannelList(vtkDataSet *, int, std::string);

    virtual vtkPolyData* createPoint( avtVector startPoint,
                                     avtVector stopPoint,
                                     bool allocateScalars );
  
    virtual vtkPolyData* createLine( avtVector startPoint,
                                    avtVector stopPoint,
                                    bool allocateScalars );
  
    virtual vtkDataSet* createCone( avtVector startPoint,
                                    avtVector stopPoint,
                                    avtVector normal,
                                    double radius,
                                    double divergence,
                                    bool allocateScalars );

    avtVector ProjectPointOnPlane( avtVector planePoint,
                                   avtVector planeNormal,
                                   avtVector point,
                                   avtVector direction );

    void applyTransform( vtkTransform* transform, avtVector &point );

    void checkBounds( vtkDataSet *in_ds,
                      avtVector &startPoint, avtVector &stopPoint );

    unsigned int checkWall( avtVector &startPoint, avtVector &stopPoint );

    std::vector< std::vector< std::pair< avtVector, float > > > lineSamples;

    vtkDataSet *composite_ds;

    int nTimeSteps;
    double cachedAngle;

    bool validTimeAxis;
    double lastTimeAxisValue;
};
#endif
