// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: LineSamplerPluginInfo.C
// ****************************************************************************

#include <LineSamplerPluginInfo.h>
#include <LineSamplerAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(LineSampler,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(LineSampler,General)

// ****************************************************************************
//  Method: LineSamplerGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
LineSamplerGeneralPluginInfo::GetName() const
{
    return "LineSampler";
}

// ****************************************************************************
//  Method: LineSamplerGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
LineSamplerGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: LineSamplerGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
LineSamplerGeneralPluginInfo::GetID() const
{
    return "LineSampler_1.0";
}
// ****************************************************************************
//  Method: LineSamplerGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
LineSamplerGeneralPluginInfo::EnabledByDefault() const
{
    return false;
}

// ****************************************************************************
//  Method: LineSamplerGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
LineSamplerGeneralPluginInfo::GetCategoryName() const
{
    return "Slicing";
}
