// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: LineSamplerGUIPluginInfo.C
// ****************************************************************************

#include <LineSamplerPluginInfo.h>
#include <LineSamplerAttributes.h>
#include <QApplication>
#include <QvisLineSamplerWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(LineSampler,GUI)

// ****************************************************************************
//  Method: LineSamplerGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
LineSamplerGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "LineSampler"));
}


// ****************************************************************************
//  Method: LineSamplerGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
LineSamplerGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisLineSamplerWindow(type, (LineSamplerAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: LineSamplerGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <LineSampler.xpm>
const char **
LineSamplerGUIPluginInfo::XPMIconData() const
{
    return LineSampler_xpm;
}

