// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: LimitCycleViewerEnginePluginInfo.C
// ****************************************************************************

#include <LimitCyclePluginInfo.h>
#include <LimitCycleAttributes.h>

//
// Storage for static data elements.
//
LimitCycleAttributes *LimitCycleViewerEnginePluginInfo::clientAtts = NULL;
LimitCycleAttributes *LimitCycleViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  LimitCycleViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
LimitCycleViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (LimitCycleViewerEnginePluginInfo::clientAtts == NULL)
    {
        LimitCycleViewerEnginePluginInfo::clientAtts  = new LimitCycleAttributes;
        LimitCycleViewerEnginePluginInfo::defaultAtts = new LimitCycleAttributes;
    }
}

// ****************************************************************************
//  Method: LimitCycleViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
LimitCycleViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: LimitCycleViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
LimitCycleViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: LimitCycleViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LimitCycleViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(LimitCycleAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: LimitCycleViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LimitCycleViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(LimitCycleAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: LimitCycleViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LimitCycleViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(LimitCycleAttributes*)atts = *defaultAtts;
    else
        *(LimitCycleAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: LimitCycleViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LimitCycleViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: LimitCycleViewerEnginePluginInfo::GetOperatorVarDescription
//
//  Purpose:
//    Return the operator variable description.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: Allen Sanderson
//  Creation:   19 August 2013
//
// ****************************************************************************

#include <avtPlotMetaData.h>
#include <cstring>
std::string
LimitCycleViewerEnginePluginInfo::GetOperatorVarDescription(AttributeSubject *atts,
                                                               const avtPlotMetaData &plot)
{
    LimitCycleAttributes *atts_in = (LimitCycleAttributes *)atts;

    const char *typeString[11] =
      { "None", "Seed Point ID", "Speed", "Vorticity", "Arc Length",
         "Absolute Time", "Relative Time",
         "Ave. dist. from seed", "Correlation Distance", "Difference",
         "Variable" };

    std::string var = plot.GetVariableName();

    if( strncmp(var.c_str(), "operators/LimitCycle/",
                strlen("operators/LimitCycle/")) == 0)
    {
      std::string justTheVar = var.substr(strlen("operators/LimitCycle/"));

      var = justTheVar;
    }

    else if( strncmp(var.c_str(), "operators/LCS/",
                     strlen("operators/LCS/")) == 0)
    {
      std::string justTheVar = var.substr(strlen("operators/LCS/"));

      var = justTheVar;
    }

    var += std::string(" - ") +
        std::string(typeString[atts_in->GetDataValue()]);

    if( atts_in->GetDataValue() == LimitCycleAttributes::Variable )
    {
        var += std::string(": ") + atts_in->GetDataVariable();
    }

    return var;
}

// ****************************************************************************
//  Method: LimitCycleViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
LimitCycleViewerEnginePluginInfo::GetMenuName() const
{
    return "LimitCycle";
}

