// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  LimitCycleScriptingPluginInfo.C
// ************************************************************************* //
#include <PyLimitCycleAttributes.h>
#include <LimitCyclePluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(LimitCycle,Scripting)

// ****************************************************************************
// Method: LimitCycleScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
LimitCycleScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyLimitCycleAttributes_StartUp((LimitCycleAttributes *)subj, data);
}

// ****************************************************************************
// Method: LimitCycleScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
LimitCycleScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyLimitCycleAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: LimitCycleScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is LimitCycle plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
LimitCycleScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyLimitCycleAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: LimitCycleScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
LimitCycleScriptingPluginInfo::GetLogString()
{
    std::string s(PyLimitCycleAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: LimitCycleScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
LimitCycleScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyLimitCycleAttributes_SetDefaults((const LimitCycleAttributes *)atts);
}
