// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtLagrangianFilter.h
// ************************************************************************* //

#ifndef AVT_Lagrangian_FILTER_H
#define AVT_Lagrangian_FILTER_H

#include <avtPICSFilter.h>
#include <avtPluginFilter.h>

#include <LagrangianAttributes.h>


class vtkDataSet;


// ****************************************************************************
//  Class: avtLagrangianFilter
//
//  Purpose:
//      A plugin operator for Lagrangian.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Wed Mar 7 14:22:35 PST 2012
//
// ****************************************************************************

class avtLagrangianFilter : public avtPluginFilter,
                            public avtPICSFilter
{
  public:
                         avtLagrangianFilter();
    virtual             ~avtLagrangianFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtLagrangianFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Lagrangian"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

    virtual avtContract_p   ModifyContract(avtContract_p);
    virtual void            UpdateDataObjectInfo(void);

    virtual void            CreateIntegralCurveOutput(std::vector<avtIntegralCurve *> &);
    virtual avtIntegralCurve* CreateIntegralCurve();
    virtual avtIntegralCurve* CreateIntegralCurve(const avtIVPSolver*, avtIntegralCurve::Direction, const double&, const avtVector&, const avtVector&, long int);
    virtual bool              GetAllSeedsSentToAllProcs() { return true; };

    virtual std::vector<avtVector> GetInitialLocations();
    virtual std::vector<avtVector> GetInitialVelocities()
                          { return std::vector<avtVector>(); };
    virtual CommunicationPattern GetCommunicationPattern() 
                          { return ReturnToOriginatingProcessor; };

    virtual avtIVPField* GetFieldForDomain(const BlockIDType& dom,
                                           vtkDataSet* ds);

  protected:
    LagrangianAttributes   atts;
    std::string        outVarName;
};


#endif
