// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: LagrangianGUIPluginInfo.C
// ****************************************************************************

#include <LagrangianPluginInfo.h>
#include <LagrangianAttributes.h>
#include <QApplication>
#include <QvisLagrangianWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Lagrangian,GUI)

// ****************************************************************************
//  Method: LagrangianGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
LagrangianGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "Lagrangian"));
}


// ****************************************************************************
//  Method: LagrangianGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
LagrangianGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisLagrangianWindow(type, (LagrangianAttributes *)attr,
        caption, shortName, notepad);
}

