// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  LCSScriptingPluginInfo.C
// ************************************************************************* //
#include <PyLCSAttributes.h>
#include <LCSPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(LCS,Scripting)

// ****************************************************************************
// Method: LCSScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
LCSScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyLCSAttributes_StartUp((LCSAttributes *)subj, data);
}

// ****************************************************************************
// Method: LCSScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
LCSScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyLCSAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: LCSScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is LCS plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
LCSScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyLCSAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: LCSScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
LCSScriptingPluginInfo::GetLogString()
{
    std::string s(PyLCSAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: LCSScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
LCSScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyLCSAttributes_SetDefaults((const LCSAttributes *)atts);
}
