// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: LCSGUIPluginInfo.C
// ****************************************************************************

#include <LCSPluginInfo.h>
#include <LCSAttributes.h>
#include <QApplication>
#include <QvisLCSWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(LCS,GUI)

// ****************************************************************************
//  Method: LCSGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
LCSGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "LCS"));
}


// ****************************************************************************
//  Method: LCSGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
LCSGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisLCSWindow(type, (LCSAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: LCSGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <LCS.xpm>
const char **
LCSGUIPluginInfo::XPMIconData() const
{
    return LCS_xpm;
}

