// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: IsovolumePluginInfo.C
// ****************************************************************************

#include <IsovolumePluginInfo.h>
#include <IsovolumeAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Isovolume,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(Isovolume,General)

// ****************************************************************************
//  Method: IsovolumeGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
IsovolumeGeneralPluginInfo::GetName() const
{
    return "Isovolume";
}

// ****************************************************************************
//  Method: IsovolumeGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
IsovolumeGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: IsovolumeGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
IsovolumeGeneralPluginInfo::GetID() const
{
    return "Isovolume_1.0";
}
// ****************************************************************************
//  Method: IsovolumeGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
IsovolumeGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: IsovolumeGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
IsovolumeGeneralPluginInfo::GetCategoryName() const
{
    return "Selection";
}
