// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: IsovolumeAttributes
//
// Purpose:
//    This class contains attributes for the isovolume operator.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class IsovolumeAttributes extends AttributeSubject implements Plugin
{
    private static int IsovolumeAttributes_numAdditionalAtts = 3;

    public IsovolumeAttributes()
    {
        super(IsovolumeAttributes_numAdditionalAtts);

        lbound = -1e+37;
        ubound = 1e+37;
        variable = new String("default");
    }

    public IsovolumeAttributes(int nMoreFields)
    {
        super(IsovolumeAttributes_numAdditionalAtts + nMoreFields);

        lbound = -1e+37;
        ubound = 1e+37;
        variable = new String("default");
    }

    public IsovolumeAttributes(IsovolumeAttributes obj)
    {
        super(obj);

        lbound = obj.lbound;
        ubound = obj.ubound;
        variable = new String(obj.variable);

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return IsovolumeAttributes_numAdditionalAtts;
    }

    public boolean equals(IsovolumeAttributes obj)
    {
        // Create the return value
        return ((lbound == obj.lbound) &&
                (ubound == obj.ubound) &&
                (variable.equals(obj.variable)));
    }

    public String GetName() { return "Isovolume"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetLbound(double lbound_)
    {
        lbound = lbound_;
        Select(0);
    }

    public void SetUbound(double ubound_)
    {
        ubound = ubound_;
        Select(1);
    }

    public void SetVariable(String variable_)
    {
        variable = variable_;
        Select(2);
    }

    // Property getting methods
    public double GetLbound() { return lbound; }
    public double GetUbound() { return ubound; }
    public String GetVariable() { return variable; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteDouble(lbound);
        if(WriteSelect(1, buf))
            buf.WriteDouble(ubound);
        if(WriteSelect(2, buf))
            buf.WriteString(variable);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetLbound(buf.ReadDouble());
            break;
        case 1:
            SetUbound(buf.ReadDouble());
            break;
        case 2:
            SetVariable(buf.ReadString());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + doubleToString("lbound", lbound, indent) + "\n";
        str = str + doubleToString("ubound", ubound, indent) + "\n";
        str = str + stringToString("variable", variable, indent) + "\n";
        return str;
    }


    // Attributes
    private double lbound;
    private double ubound;
    private String variable;
}

