// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef ISOVOLUMEATTRIBUTES_H
#define ISOVOLUMEATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: IsovolumeAttributes
//
// Purpose:
//    This class contains attributes for the isovolume operator.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class IsovolumeAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    IsovolumeAttributes();
    IsovolumeAttributes(const IsovolumeAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    IsovolumeAttributes(private_tmfs_t tmfs);
    IsovolumeAttributes(const IsovolumeAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~IsovolumeAttributes();

    virtual IsovolumeAttributes& operator = (const IsovolumeAttributes &obj);
    virtual bool operator == (const IsovolumeAttributes &obj) const;
    virtual bool operator != (const IsovolumeAttributes &obj) const;
private:
    void Init();
    void Copy(const IsovolumeAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectVariable();

    // Property setting methods
    void SetLbound(double lbound_);
    void SetUbound(double ubound_);
    void SetVariable(const std::string &variable_);

    // Property getting methods
    double            GetLbound() const;
    double            GetUbound() const;
    const std::string &GetVariable() const;
          std::string &GetVariable();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_lbound = 0,
        ID_ubound,
        ID_variable,
        ID__LAST
    };

private:
    double      lbound;
    double      ubound;
    std::string variable;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define ISOVOLUMEATTRIBUTES_TMFS "dds"

#endif
