// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <IsovolumeAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: IsovolumeAttributes::IsovolumeAttributes
//
// Purpose:
//   Init utility for the IsovolumeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void IsovolumeAttributes::Init()
{
    lbound = -1e+37;
    ubound = 1e+37;

    IsovolumeAttributes::SelectAll();
}

// ****************************************************************************
// Method: IsovolumeAttributes::IsovolumeAttributes
//
// Purpose:
//   Copy utility for the IsovolumeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void IsovolumeAttributes::Copy(const IsovolumeAttributes &obj)
{
    lbound = obj.lbound;
    ubound = obj.ubound;
    variable = obj.variable;

    IsovolumeAttributes::SelectAll();
}

// Type map format string
const char *IsovolumeAttributes::TypeMapFormatString = ISOVOLUMEATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t IsovolumeAttributes::TmfsStruct = {ISOVOLUMEATTRIBUTES_TMFS};


// ****************************************************************************
// Method: IsovolumeAttributes::IsovolumeAttributes
//
// Purpose:
//   Default constructor for the IsovolumeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

IsovolumeAttributes::IsovolumeAttributes() :
    AttributeSubject(IsovolumeAttributes::TypeMapFormatString),
    variable("default")
{
    IsovolumeAttributes::Init();
}

// ****************************************************************************
// Method: IsovolumeAttributes::IsovolumeAttributes
//
// Purpose:
//   Constructor for the derived classes of IsovolumeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

IsovolumeAttributes::IsovolumeAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs),
    variable("default")
{
    IsovolumeAttributes::Init();
}

// ****************************************************************************
// Method: IsovolumeAttributes::IsovolumeAttributes
//
// Purpose:
//   Copy constructor for the IsovolumeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

IsovolumeAttributes::IsovolumeAttributes(const IsovolumeAttributes &obj) :
    AttributeSubject(IsovolumeAttributes::TypeMapFormatString)
{
    IsovolumeAttributes::Copy(obj);
}

// ****************************************************************************
// Method: IsovolumeAttributes::IsovolumeAttributes
//
// Purpose:
//   Copy constructor for derived classes of the IsovolumeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

IsovolumeAttributes::IsovolumeAttributes(const IsovolumeAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    IsovolumeAttributes::Copy(obj);
}

// ****************************************************************************
// Method: IsovolumeAttributes::~IsovolumeAttributes
//
// Purpose:
//   Destructor for the IsovolumeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

IsovolumeAttributes::~IsovolumeAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: IsovolumeAttributes::operator =
//
// Purpose:
//   Assignment operator for the IsovolumeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

IsovolumeAttributes&
IsovolumeAttributes::operator = (const IsovolumeAttributes &obj)
{
    if (this == &obj) return *this;

    IsovolumeAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: IsovolumeAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the IsovolumeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
IsovolumeAttributes::operator == (const IsovolumeAttributes &obj) const
{
    // Create the return value
    return ((lbound == obj.lbound) &&
            (ubound == obj.ubound) &&
            (variable == obj.variable));
}

// ****************************************************************************
// Method: IsovolumeAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the IsovolumeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
IsovolumeAttributes::operator != (const IsovolumeAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: IsovolumeAttributes::TypeName
//
// Purpose:
//   Type name method for the IsovolumeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
IsovolumeAttributes::TypeName() const
{
    return "IsovolumeAttributes";
}

// ****************************************************************************
// Method: IsovolumeAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the IsovolumeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
IsovolumeAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const IsovolumeAttributes *tmp = (const IsovolumeAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: IsovolumeAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the IsovolumeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
IsovolumeAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new IsovolumeAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: IsovolumeAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the IsovolumeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
IsovolumeAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new IsovolumeAttributes(*this);
    else
        retval = new IsovolumeAttributes;

    return retval;
}

// ****************************************************************************
// Method: IsovolumeAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
IsovolumeAttributes::SelectAll()
{
    Select(ID_lbound,   (void *)&lbound);
    Select(ID_ubound,   (void *)&ubound);
    Select(ID_variable, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: IsovolumeAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
IsovolumeAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    IsovolumeAttributes defaultObject;
    bool addToParent = false;
    // Create a node for IsovolumeAttributes.
    DataNode *node = new DataNode("IsovolumeAttributes");

    if(completeSave || !FieldsEqual(ID_lbound, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lbound", lbound));
    }

    if(completeSave || !FieldsEqual(ID_ubound, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("ubound", ubound));
    }

    if(completeSave || !FieldsEqual(ID_variable, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("variable", variable));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: IsovolumeAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
IsovolumeAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("IsovolumeAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("lbound")) != 0)
        SetLbound(node->AsDouble());
    if((node = searchNode->GetNode("ubound")) != 0)
        SetUbound(node->AsDouble());
    if((node = searchNode->GetNode("variable")) != 0)
        SetVariable(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
IsovolumeAttributes::SetLbound(double lbound_)
{
    lbound = lbound_;
    Select(ID_lbound, (void *)&lbound);
}

void
IsovolumeAttributes::SetUbound(double ubound_)
{
    ubound = ubound_;
    Select(ID_ubound, (void *)&ubound);
}

void
IsovolumeAttributes::SetVariable(const std::string &variable_)
{
    variable = variable_;
    Select(ID_variable, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

double
IsovolumeAttributes::GetLbound() const
{
    return lbound;
}

double
IsovolumeAttributes::GetUbound() const
{
    return ubound;
}

const std::string &
IsovolumeAttributes::GetVariable() const
{
    return variable;
}

std::string &
IsovolumeAttributes::GetVariable()
{
    return variable;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
IsovolumeAttributes::SelectVariable()
{
    Select(ID_variable, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: IsovolumeAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
IsovolumeAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_lbound:   return "lbound";
    case ID_ubound:   return "ubound";
    case ID_variable: return "variable";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: IsovolumeAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
IsovolumeAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_lbound:   return FieldType_double;
    case ID_ubound:   return FieldType_double;
    case ID_variable: return FieldType_variablename;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: IsovolumeAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
IsovolumeAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_lbound:   return "double";
    case ID_ubound:   return "double";
    case ID_variable: return "variablename";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: IsovolumeAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
IsovolumeAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const IsovolumeAttributes &obj = *((const IsovolumeAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_lbound:
        {  // new scope
        retval = (lbound == obj.lbound);
        }
        break;
    case ID_ubound:
        {  // new scope
        retval = (ubound == obj.ubound);
        }
        break;
    case ID_variable:
        {  // new scope
        retval = (variable == obj.variable);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

