// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: IsosurfaceViewerEnginePluginInfo.C
// ****************************************************************************

#include <IsosurfacePluginInfo.h>
#include <IsosurfaceAttributes.h>

//
// Storage for static data elements.
//
IsosurfaceAttributes *IsosurfaceViewerEnginePluginInfo::clientAtts = NULL;
IsosurfaceAttributes *IsosurfaceViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  IsosurfaceViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
IsosurfaceViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (IsosurfaceViewerEnginePluginInfo::clientAtts == NULL)
    {
        IsosurfaceViewerEnginePluginInfo::clientAtts  = new IsosurfaceAttributes;
        IsosurfaceViewerEnginePluginInfo::defaultAtts = new IsosurfaceAttributes;
    }
}

// ****************************************************************************
//  Method: IsosurfaceViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
IsosurfaceViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: IsosurfaceViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
IsosurfaceViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: IsosurfaceViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
IsosurfaceViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(IsosurfaceAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: IsosurfaceViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
IsosurfaceViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(IsosurfaceAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: IsosurfaceViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
IsosurfaceViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(IsosurfaceAttributes*)atts = *defaultAtts;
    else
        *(IsosurfaceAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: IsosurfaceViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
IsosurfaceViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: IsosurfaceViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
IsosurfaceViewerEnginePluginInfo::GetMenuName() const
{
    return "Isosurface";
}

