// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: IsosurfacePluginInfo.C
// ****************************************************************************

#include <IsosurfacePluginInfo.h>
#include <IsosurfaceAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Isosurface,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(Isosurface,General)

// ****************************************************************************
//  Method: IsosurfaceGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
IsosurfaceGeneralPluginInfo::GetName() const
{
    return "Isosurface";
}

// ****************************************************************************
//  Method: IsosurfaceGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
IsosurfaceGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: IsosurfaceGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
IsosurfaceGeneralPluginInfo::GetID() const
{
    return "Isosurface_1.0";
}
// ****************************************************************************
//  Method: IsosurfaceGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
IsosurfaceGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: IsosurfaceGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
IsosurfaceGeneralPluginInfo::GetCategoryName() const
{
    return "Slicing";
}
