// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyIntegralCurveAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyIntegralCurveAttributes
//
// Purpose:
//   Attributes for the IntegralCurve
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a IntegralCurveAttributes.
//
struct IntegralCurveAttributesObject
{
    PyObject_HEAD
    IntegralCurveAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewIntegralCurveAttributes(int);

std::string
PyIntegralCurveAttributes_ToString(const IntegralCurveAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *sourceType_names = "SpecifiedPoint, PointList, SpecifiedLine, Circle, SpecifiedPlane, "
        "SpecifiedSphere, SpecifiedBox, Selection, FieldData";
    switch (atts->GetSourceType())
    {
      case IntegralCurveAttributes::SpecifiedPoint:
          snprintf(tmpStr, 1000, "%ssourceType = %sSpecifiedPoint  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::PointList:
          snprintf(tmpStr, 1000, "%ssourceType = %sPointList  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::SpecifiedLine:
          snprintf(tmpStr, 1000, "%ssourceType = %sSpecifiedLine  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::Circle:
          snprintf(tmpStr, 1000, "%ssourceType = %sCircle  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::SpecifiedPlane:
          snprintf(tmpStr, 1000, "%ssourceType = %sSpecifiedPlane  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::SpecifiedSphere:
          snprintf(tmpStr, 1000, "%ssourceType = %sSpecifiedSphere  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::SpecifiedBox:
          snprintf(tmpStr, 1000, "%ssourceType = %sSpecifiedBox  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::Selection:
          snprintf(tmpStr, 1000, "%ssourceType = %sSelection  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::FieldData:
          snprintf(tmpStr, 1000, "%ssourceType = %sFieldData  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    {   const double *pointSource = atts->GetPointSource();
        snprintf(tmpStr, 1000, "%spointSource = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", pointSource[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *lineStart = atts->GetLineStart();
        snprintf(tmpStr, 1000, "%slineStart = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", lineStart[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *lineEnd = atts->GetLineEnd();
        snprintf(tmpStr, 1000, "%slineEnd = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", lineEnd[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *planeOrigin = atts->GetPlaneOrigin();
        snprintf(tmpStr, 1000, "%splaneOrigin = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", planeOrigin[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *planeNormal = atts->GetPlaneNormal();
        snprintf(tmpStr, 1000, "%splaneNormal = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", planeNormal[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *planeUpAxis = atts->GetPlaneUpAxis();
        snprintf(tmpStr, 1000, "%splaneUpAxis = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", planeUpAxis[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    snprintf(tmpStr, 1000, "%sradius = %g\n", prefix, atts->GetRadius());
    str += tmpStr;
    {   const double *sphereOrigin = atts->GetSphereOrigin();
        snprintf(tmpStr, 1000, "%ssphereOrigin = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", sphereOrigin[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *boxExtents = atts->GetBoxExtents();
        snprintf(tmpStr, 1000, "%sboxExtents = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 6; ++i)
        {
            snprintf(tmpStr, 1000, "%g", boxExtents[i]);
            str += tmpStr;
            if(i < 5)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetUseWholeBox())
        snprintf(tmpStr, 1000, "%suseWholeBox = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%suseWholeBox = 0\n", prefix);
    str += tmpStr;
    {   const doubleVector &pointList = atts->GetPointList();
        snprintf(tmpStr, 1000, "%spointList = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < pointList.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%g", pointList[i]);
            str += tmpStr;
            if(i < pointList.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &fieldData = atts->GetFieldData();
        snprintf(tmpStr, 1000, "%sfieldData = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < fieldData.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%g", fieldData[i]);
            str += tmpStr;
            if(i < fieldData.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    snprintf(tmpStr, 1000, "%ssampleDensity0 = %d\n", prefix, atts->GetSampleDensity0());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%ssampleDensity1 = %d\n", prefix, atts->GetSampleDensity1());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%ssampleDensity2 = %d\n", prefix, atts->GetSampleDensity2());
    str += tmpStr;
    const char *dataValue_names = "Solid, SeedPointID, Speed, Vorticity, ArcLength, "
        "TimeAbsolute, TimeRelative, AverageDistanceFromSeed, CorrelationDistance, "
        "ClosedCurve, Difference, Variable";
    switch (atts->GetDataValue())
    {
      case IntegralCurveAttributes::Solid:
          snprintf(tmpStr, 1000, "%sdataValue = %sSolid  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::SeedPointID:
          snprintf(tmpStr, 1000, "%sdataValue = %sSeedPointID  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::Speed:
          snprintf(tmpStr, 1000, "%sdataValue = %sSpeed  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::Vorticity:
          snprintf(tmpStr, 1000, "%sdataValue = %sVorticity  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::ArcLength:
          snprintf(tmpStr, 1000, "%sdataValue = %sArcLength  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::TimeAbsolute:
          snprintf(tmpStr, 1000, "%sdataValue = %sTimeAbsolute  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::TimeRelative:
          snprintf(tmpStr, 1000, "%sdataValue = %sTimeRelative  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::AverageDistanceFromSeed:
          snprintf(tmpStr, 1000, "%sdataValue = %sAverageDistanceFromSeed  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::CorrelationDistance:
          snprintf(tmpStr, 1000, "%sdataValue = %sCorrelationDistance  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::ClosedCurve:
          snprintf(tmpStr, 1000, "%sdataValue = %sClosedCurve  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::Difference:
          snprintf(tmpStr, 1000, "%sdataValue = %sDifference  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::Variable:
          snprintf(tmpStr, 1000, "%sdataValue = %sVariable  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%sdataVariable = \"%s\"\n", prefix, atts->GetDataVariable().c_str());
    str += tmpStr;
    const char *integrationDirection_names = "Forward, Backward, Both, ForwardDirectionless, BackwardDirectionless, "
        "BothDirectionless";
    switch (atts->GetIntegrationDirection())
    {
      case IntegralCurveAttributes::Forward:
          snprintf(tmpStr, 1000, "%sintegrationDirection = %sForward  # %s\n", prefix, prefix, integrationDirection_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::Backward:
          snprintf(tmpStr, 1000, "%sintegrationDirection = %sBackward  # %s\n", prefix, prefix, integrationDirection_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::Both:
          snprintf(tmpStr, 1000, "%sintegrationDirection = %sBoth  # %s\n", prefix, prefix, integrationDirection_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::ForwardDirectionless:
          snprintf(tmpStr, 1000, "%sintegrationDirection = %sForwardDirectionless  # %s\n", prefix, prefix, integrationDirection_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::BackwardDirectionless:
          snprintf(tmpStr, 1000, "%sintegrationDirection = %sBackwardDirectionless  # %s\n", prefix, prefix, integrationDirection_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::BothDirectionless:
          snprintf(tmpStr, 1000, "%sintegrationDirection = %sBothDirectionless  # %s\n", prefix, prefix, integrationDirection_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%smaxSteps = %d\n", prefix, atts->GetMaxSteps());
    str += tmpStr;
    if(atts->GetTerminateByDistance())
        snprintf(tmpStr, 1000, "%sterminateByDistance = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sterminateByDistance = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%stermDistance = %g\n", prefix, atts->GetTermDistance());
    str += tmpStr;
    if(atts->GetTerminateByTime())
        snprintf(tmpStr, 1000, "%sterminateByTime = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sterminateByTime = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%stermTime = %g\n", prefix, atts->GetTermTime());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smaxStepLength = %g\n", prefix, atts->GetMaxStepLength());
    str += tmpStr;
    if(atts->GetLimitMaximumTimestep())
        snprintf(tmpStr, 1000, "%slimitMaximumTimestep = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%slimitMaximumTimestep = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smaxTimeStep = %g\n", prefix, atts->GetMaxTimeStep());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%srelTol = %g\n", prefix, atts->GetRelTol());
    str += tmpStr;
    const char *absTolSizeType_names = "Absolute, FractionOfBBox";
    switch (atts->GetAbsTolSizeType())
    {
      case IntegralCurveAttributes::Absolute:
          snprintf(tmpStr, 1000, "%sabsTolSizeType = %sAbsolute  # %s\n", prefix, prefix, absTolSizeType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::FractionOfBBox:
          snprintf(tmpStr, 1000, "%sabsTolSizeType = %sFractionOfBBox  # %s\n", prefix, prefix, absTolSizeType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%sabsTolAbsolute = %g\n", prefix, atts->GetAbsTolAbsolute());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sabsTolBBox = %g\n", prefix, atts->GetAbsTolBBox());
    str += tmpStr;
    const char *fieldType_names = "Default, FlashField, M3DC12DField, M3DC13DField, Nek5000Field, "
        "NektarPPField, NIMRODField";
    switch (atts->GetFieldType())
    {
      case IntegralCurveAttributes::Default:
          snprintf(tmpStr, 1000, "%sfieldType = %sDefault  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::FlashField:
          snprintf(tmpStr, 1000, "%sfieldType = %sFlashField  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::M3DC12DField:
          snprintf(tmpStr, 1000, "%sfieldType = %sM3DC12DField  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::M3DC13DField:
          snprintf(tmpStr, 1000, "%sfieldType = %sM3DC13DField  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::Nek5000Field:
          snprintf(tmpStr, 1000, "%sfieldType = %sNek5000Field  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::NektarPPField:
          snprintf(tmpStr, 1000, "%sfieldType = %sNektarPPField  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::NIMRODField:
          snprintf(tmpStr, 1000, "%sfieldType = %sNIMRODField  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%sfieldConstant = %g\n", prefix, atts->GetFieldConstant());
    str += tmpStr;
    {   const double *velocitySource = atts->GetVelocitySource();
        snprintf(tmpStr, 1000, "%svelocitySource = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", velocitySource[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *integrationType_names = "Euler, Leapfrog, DormandPrince, AdamsBashforth, RK4, "
        "M3DC12DIntegrator";
    switch (atts->GetIntegrationType())
    {
      case IntegralCurveAttributes::Euler:
          snprintf(tmpStr, 1000, "%sintegrationType = %sEuler  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::Leapfrog:
          snprintf(tmpStr, 1000, "%sintegrationType = %sLeapfrog  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::DormandPrince:
          snprintf(tmpStr, 1000, "%sintegrationType = %sDormandPrince  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::AdamsBashforth:
          snprintf(tmpStr, 1000, "%sintegrationType = %sAdamsBashforth  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::RK4:
          snprintf(tmpStr, 1000, "%sintegrationType = %sRK4  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::M3DC12DIntegrator:
          snprintf(tmpStr, 1000, "%sintegrationType = %sM3DC12DIntegrator  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *parallelizationAlgorithmType_names = "LoadOnDemand, ParallelStaticDomains, MasterSlave, VisItSelects";
    switch (atts->GetParallelizationAlgorithmType())
    {
      case IntegralCurveAttributes::LoadOnDemand:
          snprintf(tmpStr, 1000, "%sparallelizationAlgorithmType = %sLoadOnDemand  # %s\n", prefix, prefix, parallelizationAlgorithmType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::ParallelStaticDomains:
          snprintf(tmpStr, 1000, "%sparallelizationAlgorithmType = %sParallelStaticDomains  # %s\n", prefix, prefix, parallelizationAlgorithmType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::MasterSlave:
          snprintf(tmpStr, 1000, "%sparallelizationAlgorithmType = %sMasterSlave  # %s\n", prefix, prefix, parallelizationAlgorithmType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::VisItSelects:
          snprintf(tmpStr, 1000, "%sparallelizationAlgorithmType = %sVisItSelects  # %s\n", prefix, prefix, parallelizationAlgorithmType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%smaxProcessCount = %d\n", prefix, atts->GetMaxProcessCount());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smaxDomainCacheSize = %d\n", prefix, atts->GetMaxDomainCacheSize());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sworkGroupSize = %d\n", prefix, atts->GetWorkGroupSize());
    str += tmpStr;
    if(atts->GetPathlines())
        snprintf(tmpStr, 1000, "%spathlines = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%spathlines = 0\n", prefix);
    str += tmpStr;
    if(atts->GetPathlinesOverrideStartingTimeFlag())
        snprintf(tmpStr, 1000, "%spathlinesOverrideStartingTimeFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%spathlinesOverrideStartingTimeFlag = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%spathlinesOverrideStartingTime = %g\n", prefix, atts->GetPathlinesOverrideStartingTime());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%spathlinesPeriod = %g\n", prefix, atts->GetPathlinesPeriod());
    str += tmpStr;
    const char *pathlinesCMFE_names = "CONN_CMFE, POS_CMFE";
    switch (atts->GetPathlinesCMFE())
    {
      case IntegralCurveAttributes::CONN_CMFE:
          snprintf(tmpStr, 1000, "%spathlinesCMFE = %sCONN_CMFE  # %s\n", prefix, prefix, pathlinesCMFE_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::POS_CMFE:
          snprintf(tmpStr, 1000, "%spathlinesCMFE = %sPOS_CMFE  # %s\n", prefix, prefix, pathlinesCMFE_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *displayGeometry_names = "Lines, Tubes, Ribbons";
    switch (atts->GetDisplayGeometry())
    {
      case IntegralCurveAttributes::Lines:
          snprintf(tmpStr, 1000, "%sdisplayGeometry = %sLines  # %s\n", prefix, prefix, displayGeometry_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::Tubes:
          snprintf(tmpStr, 1000, "%sdisplayGeometry = %sTubes  # %s\n", prefix, prefix, displayGeometry_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::Ribbons:
          snprintf(tmpStr, 1000, "%sdisplayGeometry = %sRibbons  # %s\n", prefix, prefix, displayGeometry_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *cleanupMethod_names = "NoCleanup, Merge, Before, After";
    switch (atts->GetCleanupMethod())
    {
      case IntegralCurveAttributes::NoCleanup:
          snprintf(tmpStr, 1000, "%scleanupMethod = %sNoCleanup  # %s\n", prefix, prefix, cleanupMethod_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::Merge:
          snprintf(tmpStr, 1000, "%scleanupMethod = %sMerge  # %s\n", prefix, prefix, cleanupMethod_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::Before:
          snprintf(tmpStr, 1000, "%scleanupMethod = %sBefore  # %s\n", prefix, prefix, cleanupMethod_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::After:
          snprintf(tmpStr, 1000, "%scleanupMethod = %sAfter  # %s\n", prefix, prefix, cleanupMethod_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%scleanupThreshold = %g\n", prefix, atts->GetCleanupThreshold());
    str += tmpStr;
    if(atts->GetCropBeginFlag())
        snprintf(tmpStr, 1000, "%scropBeginFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%scropBeginFlag = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%scropBegin = %g\n", prefix, atts->GetCropBegin());
    str += tmpStr;
    if(atts->GetCropEndFlag())
        snprintf(tmpStr, 1000, "%scropEndFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%scropEndFlag = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%scropEnd = %g\n", prefix, atts->GetCropEnd());
    str += tmpStr;
    const char *cropValue_names = "Distance, Time, StepNumber";
    switch (atts->GetCropValue())
    {
      case IntegralCurveAttributes::Distance:
          snprintf(tmpStr, 1000, "%scropValue = %sDistance  # %s\n", prefix, prefix, cropValue_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::Time:
          snprintf(tmpStr, 1000, "%scropValue = %sTime  # %s\n", prefix, prefix, cropValue_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::StepNumber:
          snprintf(tmpStr, 1000, "%scropValue = %sStepNumber  # %s\n", prefix, prefix, cropValue_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%ssampleDistance0 = %g\n", prefix, atts->GetSampleDistance0());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%ssampleDistance1 = %g\n", prefix, atts->GetSampleDistance1());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%ssampleDistance2 = %g\n", prefix, atts->GetSampleDistance2());
    str += tmpStr;
    if(atts->GetFillInterior())
        snprintf(tmpStr, 1000, "%sfillInterior = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sfillInterior = 0\n", prefix);
    str += tmpStr;
    if(atts->GetRandomSamples())
        snprintf(tmpStr, 1000, "%srandomSamples = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%srandomSamples = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%srandomSeed = %d\n", prefix, atts->GetRandomSeed());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%snumberOfRandomSamples = %d\n", prefix, atts->GetNumberOfRandomSamples());
    str += tmpStr;
    if(atts->GetIssueAdvectionWarnings())
        snprintf(tmpStr, 1000, "%sissueAdvectionWarnings = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sissueAdvectionWarnings = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIssueBoundaryWarnings())
        snprintf(tmpStr, 1000, "%sissueBoundaryWarnings = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sissueBoundaryWarnings = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIssueTerminationWarnings())
        snprintf(tmpStr, 1000, "%sissueTerminationWarnings = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sissueTerminationWarnings = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIssueStepsizeWarnings())
        snprintf(tmpStr, 1000, "%sissueStepsizeWarnings = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sissueStepsizeWarnings = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIssueStiffnessWarnings())
        snprintf(tmpStr, 1000, "%sissueStiffnessWarnings = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sissueStiffnessWarnings = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIssueCriticalPointsWarnings())
        snprintf(tmpStr, 1000, "%sissueCriticalPointsWarnings = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sissueCriticalPointsWarnings = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%scriticalPointThreshold = %g\n", prefix, atts->GetCriticalPointThreshold());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%scorrelationDistanceAngTol = %g\n", prefix, atts->GetCorrelationDistanceAngTol());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%scorrelationDistanceMinDistAbsolute = %g\n", prefix, atts->GetCorrelationDistanceMinDistAbsolute());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%scorrelationDistanceMinDistBBox = %g\n", prefix, atts->GetCorrelationDistanceMinDistBBox());
    str += tmpStr;
    const char *correlationDistanceMinDistType_names = "Absolute, FractionOfBBox";
    switch (atts->GetCorrelationDistanceMinDistType())
    {
      case IntegralCurveAttributes::Absolute:
          snprintf(tmpStr, 1000, "%scorrelationDistanceMinDistType = %sAbsolute  # %s\n", prefix, prefix, correlationDistanceMinDistType_names);
          str += tmpStr;
          break;
      case IntegralCurveAttributes::FractionOfBBox:
          snprintf(tmpStr, 1000, "%scorrelationDistanceMinDistType = %sFractionOfBBox  # %s\n", prefix, prefix, correlationDistanceMinDistType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%sselection = \"%s\"\n", prefix, atts->GetSelection().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
IntegralCurveAttributes_Notify(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetSourceType(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sourceType in the object.
    if(ival >= 0 && ival < 9)
        obj->data->SetSourceType(IntegralCurveAttributes::SourceType(ival));
    else
    {
        fprintf(stderr, "An invalid sourceType value was given. "
                        "Valid values are in the range of [0,8]. "
                        "You can also use the following names: "
                        "SpecifiedPoint, PointList, SpecifiedLine, Circle, SpecifiedPlane, "
                        "SpecifiedSphere, SpecifiedBox, Selection, FieldData"
                        ".");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetSourceType(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSourceType()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetPointSource(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double *dvals = obj->data->GetPointSource();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the pointSource in the object as modified.
    obj->data->SelectPointSource();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetPointSource(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the pointSource.
    PyObject *retval = PyTuple_New(3);
    const double *pointSource = obj->data->GetPointSource();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(pointSource[i]));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetLineStart(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double *dvals = obj->data->GetLineStart();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the lineStart in the object as modified.
    obj->data->SelectLineStart();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetLineStart(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the lineStart.
    PyObject *retval = PyTuple_New(3);
    const double *lineStart = obj->data->GetLineStart();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(lineStart[i]));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetLineEnd(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double *dvals = obj->data->GetLineEnd();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the lineEnd in the object as modified.
    obj->data->SelectLineEnd();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetLineEnd(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the lineEnd.
    PyObject *retval = PyTuple_New(3);
    const double *lineEnd = obj->data->GetLineEnd();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(lineEnd[i]));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetPlaneOrigin(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double *dvals = obj->data->GetPlaneOrigin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the planeOrigin in the object as modified.
    obj->data->SelectPlaneOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetPlaneOrigin(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the planeOrigin.
    PyObject *retval = PyTuple_New(3);
    const double *planeOrigin = obj->data->GetPlaneOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(planeOrigin[i]));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetPlaneNormal(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double *dvals = obj->data->GetPlaneNormal();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the planeNormal in the object as modified.
    obj->data->SelectPlaneNormal();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetPlaneNormal(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the planeNormal.
    PyObject *retval = PyTuple_New(3);
    const double *planeNormal = obj->data->GetPlaneNormal();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(planeNormal[i]));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetPlaneUpAxis(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double *dvals = obj->data->GetPlaneUpAxis();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the planeUpAxis in the object as modified.
    obj->data->SelectPlaneUpAxis();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetPlaneUpAxis(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the planeUpAxis.
    PyObject *retval = PyTuple_New(3);
    const double *planeUpAxis = obj->data->GetPlaneUpAxis();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(planeUpAxis[i]));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetRadius(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the radius in the object.
    obj->data->SetRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetRadius(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRadius());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetSphereOrigin(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double *dvals = obj->data->GetSphereOrigin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the sphereOrigin in the object as modified.
    obj->data->SelectSphereOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetSphereOrigin(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the sphereOrigin.
    PyObject *retval = PyTuple_New(3);
    const double *sphereOrigin = obj->data->GetSphereOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(sphereOrigin[i]));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetBoxExtents(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double *dvals = obj->data->GetBoxExtents();
    if(!PyArg_ParseTuple(args, "dddddd", &dvals[0], &dvals[1], &dvals[2], &dvals[3], &dvals[4], &dvals[5]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 6)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the boxExtents in the object as modified.
    obj->data->SelectBoxExtents();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetBoxExtents(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the boxExtents.
    PyObject *retval = PyTuple_New(6);
    const double *boxExtents = obj->data->GetBoxExtents();
    for(int i = 0; i < 6; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(boxExtents[i]));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetUseWholeBox(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useWholeBox in the object.
    obj->data->SetUseWholeBox(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetUseWholeBox(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseWholeBox()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetPointList(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    doubleVector  &vec = obj->data->GetPointList();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the pointList in the object as modified.
    obj->data->SelectPointList();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetPointList(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the pointList.
    const doubleVector &pointList = obj->data->GetPointList();
    PyObject *retval = PyTuple_New(pointList.size());
    for(size_t i = 0; i < pointList.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(pointList[i]));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetFieldData(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    doubleVector  &vec = obj->data->GetFieldData();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the fieldData in the object as modified.
    obj->data->SelectFieldData();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetFieldData(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the fieldData.
    const doubleVector &fieldData = obj->data->GetFieldData();
    PyObject *retval = PyTuple_New(fieldData.size());
    for(size_t i = 0; i < fieldData.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(fieldData[i]));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetSampleDensity0(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sampleDensity0 in the object.
    obj->data->SetSampleDensity0((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetSampleDensity0(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSampleDensity0()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetSampleDensity1(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sampleDensity1 in the object.
    obj->data->SetSampleDensity1((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetSampleDensity1(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSampleDensity1()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetSampleDensity2(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sampleDensity2 in the object.
    obj->data->SetSampleDensity2((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetSampleDensity2(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSampleDensity2()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetDataValue(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the dataValue in the object.
    if(ival >= 0 && ival < 12)
        obj->data->SetDataValue(IntegralCurveAttributes::DataValue(ival));
    else
    {
        fprintf(stderr, "An invalid dataValue value was given. "
                        "Valid values are in the range of [0,11]. "
                        "You can also use the following names: "
                        "Solid, SeedPointID, Speed, Vorticity, ArcLength, "
                        "TimeAbsolute, TimeRelative, AverageDistanceFromSeed, CorrelationDistance, "
                        "ClosedCurve, Difference, Variable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetDataValue(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDataValue()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetDataVariable(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the dataVariable in the object.
    obj->data->SetDataVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetDataVariable(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDataVariable().c_str());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetIntegrationDirection(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the integrationDirection in the object.
    if(ival >= 0 && ival < 6)
        obj->data->SetIntegrationDirection(IntegralCurveAttributes::IntegrationDirection(ival));
    else
    {
        fprintf(stderr, "An invalid integrationDirection value was given. "
                        "Valid values are in the range of [0,5]. "
                        "You can also use the following names: "
                        "Forward, Backward, Both, ForwardDirectionless, BackwardDirectionless, "
                        "BothDirectionless.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetIntegrationDirection(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetIntegrationDirection()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetMaxSteps(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxSteps in the object.
    obj->data->SetMaxSteps((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetMaxSteps(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxSteps()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetTerminateByDistance(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the terminateByDistance in the object.
    obj->data->SetTerminateByDistance(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetTerminateByDistance(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTerminateByDistance()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetTermDistance(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the termDistance in the object.
    obj->data->SetTermDistance(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetTermDistance(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTermDistance());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetTerminateByTime(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the terminateByTime in the object.
    obj->data->SetTerminateByTime(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetTerminateByTime(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTerminateByTime()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetTermTime(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the termTime in the object.
    obj->data->SetTermTime(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetTermTime(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTermTime());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetMaxStepLength(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxStepLength in the object.
    obj->data->SetMaxStepLength(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetMaxStepLength(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaxStepLength());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetLimitMaximumTimestep(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the limitMaximumTimestep in the object.
    obj->data->SetLimitMaximumTimestep(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetLimitMaximumTimestep(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLimitMaximumTimestep()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetMaxTimeStep(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxTimeStep in the object.
    obj->data->SetMaxTimeStep(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetMaxTimeStep(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaxTimeStep());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetRelTol(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the relTol in the object.
    obj->data->SetRelTol(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetRelTol(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRelTol());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetAbsTolSizeType(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the absTolSizeType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetAbsTolSizeType(IntegralCurveAttributes::SizeType(ival));
    else
    {
        fprintf(stderr, "An invalid absTolSizeType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Absolute, FractionOfBBox.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetAbsTolSizeType(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAbsTolSizeType()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetAbsTolAbsolute(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the absTolAbsolute in the object.
    obj->data->SetAbsTolAbsolute(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetAbsTolAbsolute(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetAbsTolAbsolute());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetAbsTolBBox(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the absTolBBox in the object.
    obj->data->SetAbsTolBBox(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetAbsTolBBox(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetAbsTolBBox());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetFieldType(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fieldType in the object.
    if(ival >= 0 && ival < 7)
        obj->data->SetFieldType(IntegralCurveAttributes::FieldType(ival));
    else
    {
        fprintf(stderr, "An invalid fieldType value was given. "
                        "Valid values are in the range of [0,6]. "
                        "You can also use the following names: "
                        "Default, FlashField, M3DC12DField, M3DC13DField, Nek5000Field, "
                        "NektarPPField, NIMRODField.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetFieldType(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetFieldType()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetFieldConstant(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the fieldConstant in the object.
    obj->data->SetFieldConstant(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetFieldConstant(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetFieldConstant());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetVelocitySource(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double *dvals = obj->data->GetVelocitySource();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the velocitySource in the object as modified.
    obj->data->SelectVelocitySource();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetVelocitySource(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the velocitySource.
    PyObject *retval = PyTuple_New(3);
    const double *velocitySource = obj->data->GetVelocitySource();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(velocitySource[i]));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetIntegrationType(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the integrationType in the object.
    if(ival >= 0 && ival < 6)
        obj->data->SetIntegrationType(IntegralCurveAttributes::IntegrationType(ival));
    else
    {
        fprintf(stderr, "An invalid integrationType value was given. "
                        "Valid values are in the range of [0,5]. "
                        "You can also use the following names: "
                        "Euler, Leapfrog, DormandPrince, AdamsBashforth, RK4, "
                        "M3DC12DIntegrator.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetIntegrationType(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetIntegrationType()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetParallelizationAlgorithmType(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the parallelizationAlgorithmType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetParallelizationAlgorithmType(IntegralCurveAttributes::ParallelizationAlgorithmType(ival));
    else
    {
        fprintf(stderr, "An invalid parallelizationAlgorithmType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "LoadOnDemand, ParallelStaticDomains, MasterSlave, VisItSelects.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetParallelizationAlgorithmType(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetParallelizationAlgorithmType()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetMaxProcessCount(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxProcessCount in the object.
    obj->data->SetMaxProcessCount((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetMaxProcessCount(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxProcessCount()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetMaxDomainCacheSize(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxDomainCacheSize in the object.
    obj->data->SetMaxDomainCacheSize((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetMaxDomainCacheSize(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxDomainCacheSize()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetWorkGroupSize(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the workGroupSize in the object.
    obj->data->SetWorkGroupSize((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetWorkGroupSize(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWorkGroupSize()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetPathlines(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pathlines in the object.
    obj->data->SetPathlines(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetPathlines(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPathlines()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetPathlinesOverrideStartingTimeFlag(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pathlinesOverrideStartingTimeFlag in the object.
    obj->data->SetPathlinesOverrideStartingTimeFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetPathlinesOverrideStartingTimeFlag(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPathlinesOverrideStartingTimeFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetPathlinesOverrideStartingTime(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pathlinesOverrideStartingTime in the object.
    obj->data->SetPathlinesOverrideStartingTime(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetPathlinesOverrideStartingTime(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPathlinesOverrideStartingTime());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetPathlinesPeriod(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pathlinesPeriod in the object.
    obj->data->SetPathlinesPeriod(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetPathlinesPeriod(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPathlinesPeriod());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetPathlinesCMFE(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pathlinesCMFE in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetPathlinesCMFE(IntegralCurveAttributes::PathlinesCMFE(ival));
    else
    {
        fprintf(stderr, "An invalid pathlinesCMFE value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "CONN_CMFE, POS_CMFE.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetPathlinesCMFE(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPathlinesCMFE()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetDisplayGeometry(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the displayGeometry in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetDisplayGeometry(IntegralCurveAttributes::DisplayGeometry(ival));
    else
    {
        fprintf(stderr, "An invalid displayGeometry value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Lines, Tubes, Ribbons.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetDisplayGeometry(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDisplayGeometry()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetCleanupMethod(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cleanupMethod in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetCleanupMethod(IntegralCurveAttributes::CleanupMethod(ival));
    else
    {
        fprintf(stderr, "An invalid cleanupMethod value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "NoCleanup, Merge, Before, After.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetCleanupMethod(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCleanupMethod()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetCleanupThreshold(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the cleanupThreshold in the object.
    obj->data->SetCleanupThreshold(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetCleanupThreshold(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetCleanupThreshold());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetCropBeginFlag(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cropBeginFlag in the object.
    obj->data->SetCropBeginFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetCropBeginFlag(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCropBeginFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetCropBegin(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the cropBegin in the object.
    obj->data->SetCropBegin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetCropBegin(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetCropBegin());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetCropEndFlag(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cropEndFlag in the object.
    obj->data->SetCropEndFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetCropEndFlag(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCropEndFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetCropEnd(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the cropEnd in the object.
    obj->data->SetCropEnd(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetCropEnd(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetCropEnd());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetCropValue(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cropValue in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetCropValue(IntegralCurveAttributes::CropValue(ival));
    else
    {
        fprintf(stderr, "An invalid cropValue value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Distance, Time, StepNumber.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetCropValue(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCropValue()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetSampleDistance0(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the sampleDistance0 in the object.
    obj->data->SetSampleDistance0(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetSampleDistance0(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSampleDistance0());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetSampleDistance1(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the sampleDistance1 in the object.
    obj->data->SetSampleDistance1(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetSampleDistance1(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSampleDistance1());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetSampleDistance2(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the sampleDistance2 in the object.
    obj->data->SetSampleDistance2(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetSampleDistance2(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSampleDistance2());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetFillInterior(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fillInterior in the object.
    obj->data->SetFillInterior(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetFillInterior(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFillInterior()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetRandomSamples(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the randomSamples in the object.
    obj->data->SetRandomSamples(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetRandomSamples(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetRandomSamples()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetRandomSeed(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the randomSeed in the object.
    obj->data->SetRandomSeed((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetRandomSeed(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRandomSeed()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetNumberOfRandomSamples(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numberOfRandomSamples in the object.
    obj->data->SetNumberOfRandomSamples((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetNumberOfRandomSamples(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumberOfRandomSamples()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetIssueAdvectionWarnings(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueAdvectionWarnings in the object.
    obj->data->SetIssueAdvectionWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetIssueAdvectionWarnings(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueAdvectionWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetIssueBoundaryWarnings(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueBoundaryWarnings in the object.
    obj->data->SetIssueBoundaryWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetIssueBoundaryWarnings(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueBoundaryWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetIssueTerminationWarnings(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueTerminationWarnings in the object.
    obj->data->SetIssueTerminationWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetIssueTerminationWarnings(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueTerminationWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetIssueStepsizeWarnings(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueStepsizeWarnings in the object.
    obj->data->SetIssueStepsizeWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetIssueStepsizeWarnings(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueStepsizeWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetIssueStiffnessWarnings(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueStiffnessWarnings in the object.
    obj->data->SetIssueStiffnessWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetIssueStiffnessWarnings(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueStiffnessWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetIssueCriticalPointsWarnings(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueCriticalPointsWarnings in the object.
    obj->data->SetIssueCriticalPointsWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetIssueCriticalPointsWarnings(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueCriticalPointsWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetCriticalPointThreshold(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the criticalPointThreshold in the object.
    obj->data->SetCriticalPointThreshold(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetCriticalPointThreshold(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetCriticalPointThreshold());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetCorrelationDistanceAngTol(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the correlationDistanceAngTol in the object.
    obj->data->SetCorrelationDistanceAngTol(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetCorrelationDistanceAngTol(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetCorrelationDistanceAngTol());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetCorrelationDistanceMinDistAbsolute(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the correlationDistanceMinDistAbsolute in the object.
    obj->data->SetCorrelationDistanceMinDistAbsolute(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetCorrelationDistanceMinDistAbsolute(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetCorrelationDistanceMinDistAbsolute());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetCorrelationDistanceMinDistBBox(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the correlationDistanceMinDistBBox in the object.
    obj->data->SetCorrelationDistanceMinDistBBox(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetCorrelationDistanceMinDistBBox(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetCorrelationDistanceMinDistBBox());
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetCorrelationDistanceMinDistType(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the correlationDistanceMinDistType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetCorrelationDistanceMinDistType(IntegralCurveAttributes::SizeType(ival));
    else
    {
        fprintf(stderr, "An invalid correlationDistanceMinDistType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Absolute, FractionOfBBox.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetCorrelationDistanceMinDistType(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCorrelationDistanceMinDistType()));
    return retval;
}

/*static*/ PyObject *
IntegralCurveAttributes_SetSelection(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the selection in the object.
    obj->data->SetSelection(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IntegralCurveAttributes_GetSelection(PyObject *self, PyObject *args)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetSelection().c_str());
    return retval;
}



PyMethodDef PyIntegralCurveAttributes_methods[INTEGRALCURVEATTRIBUTES_NMETH] = {
    {"Notify", IntegralCurveAttributes_Notify, METH_VARARGS},
    {"SetSourceType", IntegralCurveAttributes_SetSourceType, METH_VARARGS},
    {"GetSourceType", IntegralCurveAttributes_GetSourceType, METH_VARARGS},
    {"SetPointSource", IntegralCurveAttributes_SetPointSource, METH_VARARGS},
    {"GetPointSource", IntegralCurveAttributes_GetPointSource, METH_VARARGS},
    {"SetLineStart", IntegralCurveAttributes_SetLineStart, METH_VARARGS},
    {"GetLineStart", IntegralCurveAttributes_GetLineStart, METH_VARARGS},
    {"SetLineEnd", IntegralCurveAttributes_SetLineEnd, METH_VARARGS},
    {"GetLineEnd", IntegralCurveAttributes_GetLineEnd, METH_VARARGS},
    {"SetPlaneOrigin", IntegralCurveAttributes_SetPlaneOrigin, METH_VARARGS},
    {"GetPlaneOrigin", IntegralCurveAttributes_GetPlaneOrigin, METH_VARARGS},
    {"SetPlaneNormal", IntegralCurveAttributes_SetPlaneNormal, METH_VARARGS},
    {"GetPlaneNormal", IntegralCurveAttributes_GetPlaneNormal, METH_VARARGS},
    {"SetPlaneUpAxis", IntegralCurveAttributes_SetPlaneUpAxis, METH_VARARGS},
    {"GetPlaneUpAxis", IntegralCurveAttributes_GetPlaneUpAxis, METH_VARARGS},
    {"SetRadius", IntegralCurveAttributes_SetRadius, METH_VARARGS},
    {"GetRadius", IntegralCurveAttributes_GetRadius, METH_VARARGS},
    {"SetSphereOrigin", IntegralCurveAttributes_SetSphereOrigin, METH_VARARGS},
    {"GetSphereOrigin", IntegralCurveAttributes_GetSphereOrigin, METH_VARARGS},
    {"SetBoxExtents", IntegralCurveAttributes_SetBoxExtents, METH_VARARGS},
    {"GetBoxExtents", IntegralCurveAttributes_GetBoxExtents, METH_VARARGS},
    {"SetUseWholeBox", IntegralCurveAttributes_SetUseWholeBox, METH_VARARGS},
    {"GetUseWholeBox", IntegralCurveAttributes_GetUseWholeBox, METH_VARARGS},
    {"SetPointList", IntegralCurveAttributes_SetPointList, METH_VARARGS},
    {"GetPointList", IntegralCurveAttributes_GetPointList, METH_VARARGS},
    {"SetFieldData", IntegralCurveAttributes_SetFieldData, METH_VARARGS},
    {"GetFieldData", IntegralCurveAttributes_GetFieldData, METH_VARARGS},
    {"SetSampleDensity0", IntegralCurveAttributes_SetSampleDensity0, METH_VARARGS},
    {"GetSampleDensity0", IntegralCurveAttributes_GetSampleDensity0, METH_VARARGS},
    {"SetSampleDensity1", IntegralCurveAttributes_SetSampleDensity1, METH_VARARGS},
    {"GetSampleDensity1", IntegralCurveAttributes_GetSampleDensity1, METH_VARARGS},
    {"SetSampleDensity2", IntegralCurveAttributes_SetSampleDensity2, METH_VARARGS},
    {"GetSampleDensity2", IntegralCurveAttributes_GetSampleDensity2, METH_VARARGS},
    {"SetDataValue", IntegralCurveAttributes_SetDataValue, METH_VARARGS},
    {"GetDataValue", IntegralCurveAttributes_GetDataValue, METH_VARARGS},
    {"SetDataVariable", IntegralCurveAttributes_SetDataVariable, METH_VARARGS},
    {"GetDataVariable", IntegralCurveAttributes_GetDataVariable, METH_VARARGS},
    {"SetIntegrationDirection", IntegralCurveAttributes_SetIntegrationDirection, METH_VARARGS},
    {"GetIntegrationDirection", IntegralCurveAttributes_GetIntegrationDirection, METH_VARARGS},
    {"SetMaxSteps", IntegralCurveAttributes_SetMaxSteps, METH_VARARGS},
    {"GetMaxSteps", IntegralCurveAttributes_GetMaxSteps, METH_VARARGS},
    {"SetTerminateByDistance", IntegralCurveAttributes_SetTerminateByDistance, METH_VARARGS},
    {"GetTerminateByDistance", IntegralCurveAttributes_GetTerminateByDistance, METH_VARARGS},
    {"SetTermDistance", IntegralCurveAttributes_SetTermDistance, METH_VARARGS},
    {"GetTermDistance", IntegralCurveAttributes_GetTermDistance, METH_VARARGS},
    {"SetTerminateByTime", IntegralCurveAttributes_SetTerminateByTime, METH_VARARGS},
    {"GetTerminateByTime", IntegralCurveAttributes_GetTerminateByTime, METH_VARARGS},
    {"SetTermTime", IntegralCurveAttributes_SetTermTime, METH_VARARGS},
    {"GetTermTime", IntegralCurveAttributes_GetTermTime, METH_VARARGS},
    {"SetMaxStepLength", IntegralCurveAttributes_SetMaxStepLength, METH_VARARGS},
    {"GetMaxStepLength", IntegralCurveAttributes_GetMaxStepLength, METH_VARARGS},
    {"SetLimitMaximumTimestep", IntegralCurveAttributes_SetLimitMaximumTimestep, METH_VARARGS},
    {"GetLimitMaximumTimestep", IntegralCurveAttributes_GetLimitMaximumTimestep, METH_VARARGS},
    {"SetMaxTimeStep", IntegralCurveAttributes_SetMaxTimeStep, METH_VARARGS},
    {"GetMaxTimeStep", IntegralCurveAttributes_GetMaxTimeStep, METH_VARARGS},
    {"SetRelTol", IntegralCurveAttributes_SetRelTol, METH_VARARGS},
    {"GetRelTol", IntegralCurveAttributes_GetRelTol, METH_VARARGS},
    {"SetAbsTolSizeType", IntegralCurveAttributes_SetAbsTolSizeType, METH_VARARGS},
    {"GetAbsTolSizeType", IntegralCurveAttributes_GetAbsTolSizeType, METH_VARARGS},
    {"SetAbsTolAbsolute", IntegralCurveAttributes_SetAbsTolAbsolute, METH_VARARGS},
    {"GetAbsTolAbsolute", IntegralCurveAttributes_GetAbsTolAbsolute, METH_VARARGS},
    {"SetAbsTolBBox", IntegralCurveAttributes_SetAbsTolBBox, METH_VARARGS},
    {"GetAbsTolBBox", IntegralCurveAttributes_GetAbsTolBBox, METH_VARARGS},
    {"SetFieldType", IntegralCurveAttributes_SetFieldType, METH_VARARGS},
    {"GetFieldType", IntegralCurveAttributes_GetFieldType, METH_VARARGS},
    {"SetFieldConstant", IntegralCurveAttributes_SetFieldConstant, METH_VARARGS},
    {"GetFieldConstant", IntegralCurveAttributes_GetFieldConstant, METH_VARARGS},
    {"SetVelocitySource", IntegralCurveAttributes_SetVelocitySource, METH_VARARGS},
    {"GetVelocitySource", IntegralCurveAttributes_GetVelocitySource, METH_VARARGS},
    {"SetIntegrationType", IntegralCurveAttributes_SetIntegrationType, METH_VARARGS},
    {"GetIntegrationType", IntegralCurveAttributes_GetIntegrationType, METH_VARARGS},
    {"SetParallelizationAlgorithmType", IntegralCurveAttributes_SetParallelizationAlgorithmType, METH_VARARGS},
    {"GetParallelizationAlgorithmType", IntegralCurveAttributes_GetParallelizationAlgorithmType, METH_VARARGS},
    {"SetMaxProcessCount", IntegralCurveAttributes_SetMaxProcessCount, METH_VARARGS},
    {"GetMaxProcessCount", IntegralCurveAttributes_GetMaxProcessCount, METH_VARARGS},
    {"SetMaxDomainCacheSize", IntegralCurveAttributes_SetMaxDomainCacheSize, METH_VARARGS},
    {"GetMaxDomainCacheSize", IntegralCurveAttributes_GetMaxDomainCacheSize, METH_VARARGS},
    {"SetWorkGroupSize", IntegralCurveAttributes_SetWorkGroupSize, METH_VARARGS},
    {"GetWorkGroupSize", IntegralCurveAttributes_GetWorkGroupSize, METH_VARARGS},
    {"SetPathlines", IntegralCurveAttributes_SetPathlines, METH_VARARGS},
    {"GetPathlines", IntegralCurveAttributes_GetPathlines, METH_VARARGS},
    {"SetPathlinesOverrideStartingTimeFlag", IntegralCurveAttributes_SetPathlinesOverrideStartingTimeFlag, METH_VARARGS},
    {"GetPathlinesOverrideStartingTimeFlag", IntegralCurveAttributes_GetPathlinesOverrideStartingTimeFlag, METH_VARARGS},
    {"SetPathlinesOverrideStartingTime", IntegralCurveAttributes_SetPathlinesOverrideStartingTime, METH_VARARGS},
    {"GetPathlinesOverrideStartingTime", IntegralCurveAttributes_GetPathlinesOverrideStartingTime, METH_VARARGS},
    {"SetPathlinesPeriod", IntegralCurveAttributes_SetPathlinesPeriod, METH_VARARGS},
    {"GetPathlinesPeriod", IntegralCurveAttributes_GetPathlinesPeriod, METH_VARARGS},
    {"SetPathlinesCMFE", IntegralCurveAttributes_SetPathlinesCMFE, METH_VARARGS},
    {"GetPathlinesCMFE", IntegralCurveAttributes_GetPathlinesCMFE, METH_VARARGS},
    {"SetDisplayGeometry", IntegralCurveAttributes_SetDisplayGeometry, METH_VARARGS},
    {"GetDisplayGeometry", IntegralCurveAttributes_GetDisplayGeometry, METH_VARARGS},
    {"SetCleanupMethod", IntegralCurveAttributes_SetCleanupMethod, METH_VARARGS},
    {"GetCleanupMethod", IntegralCurveAttributes_GetCleanupMethod, METH_VARARGS},
    {"SetCleanupThreshold", IntegralCurveAttributes_SetCleanupThreshold, METH_VARARGS},
    {"GetCleanupThreshold", IntegralCurveAttributes_GetCleanupThreshold, METH_VARARGS},
    {"SetCropBeginFlag", IntegralCurveAttributes_SetCropBeginFlag, METH_VARARGS},
    {"GetCropBeginFlag", IntegralCurveAttributes_GetCropBeginFlag, METH_VARARGS},
    {"SetCropBegin", IntegralCurveAttributes_SetCropBegin, METH_VARARGS},
    {"GetCropBegin", IntegralCurveAttributes_GetCropBegin, METH_VARARGS},
    {"SetCropEndFlag", IntegralCurveAttributes_SetCropEndFlag, METH_VARARGS},
    {"GetCropEndFlag", IntegralCurveAttributes_GetCropEndFlag, METH_VARARGS},
    {"SetCropEnd", IntegralCurveAttributes_SetCropEnd, METH_VARARGS},
    {"GetCropEnd", IntegralCurveAttributes_GetCropEnd, METH_VARARGS},
    {"SetCropValue", IntegralCurveAttributes_SetCropValue, METH_VARARGS},
    {"GetCropValue", IntegralCurveAttributes_GetCropValue, METH_VARARGS},
    {"SetSampleDistance0", IntegralCurveAttributes_SetSampleDistance0, METH_VARARGS},
    {"GetSampleDistance0", IntegralCurveAttributes_GetSampleDistance0, METH_VARARGS},
    {"SetSampleDistance1", IntegralCurveAttributes_SetSampleDistance1, METH_VARARGS},
    {"GetSampleDistance1", IntegralCurveAttributes_GetSampleDistance1, METH_VARARGS},
    {"SetSampleDistance2", IntegralCurveAttributes_SetSampleDistance2, METH_VARARGS},
    {"GetSampleDistance2", IntegralCurveAttributes_GetSampleDistance2, METH_VARARGS},
    {"SetFillInterior", IntegralCurveAttributes_SetFillInterior, METH_VARARGS},
    {"GetFillInterior", IntegralCurveAttributes_GetFillInterior, METH_VARARGS},
    {"SetRandomSamples", IntegralCurveAttributes_SetRandomSamples, METH_VARARGS},
    {"GetRandomSamples", IntegralCurveAttributes_GetRandomSamples, METH_VARARGS},
    {"SetRandomSeed", IntegralCurveAttributes_SetRandomSeed, METH_VARARGS},
    {"GetRandomSeed", IntegralCurveAttributes_GetRandomSeed, METH_VARARGS},
    {"SetNumberOfRandomSamples", IntegralCurveAttributes_SetNumberOfRandomSamples, METH_VARARGS},
    {"GetNumberOfRandomSamples", IntegralCurveAttributes_GetNumberOfRandomSamples, METH_VARARGS},
    {"SetIssueAdvectionWarnings", IntegralCurveAttributes_SetIssueAdvectionWarnings, METH_VARARGS},
    {"GetIssueAdvectionWarnings", IntegralCurveAttributes_GetIssueAdvectionWarnings, METH_VARARGS},
    {"SetIssueBoundaryWarnings", IntegralCurveAttributes_SetIssueBoundaryWarnings, METH_VARARGS},
    {"GetIssueBoundaryWarnings", IntegralCurveAttributes_GetIssueBoundaryWarnings, METH_VARARGS},
    {"SetIssueTerminationWarnings", IntegralCurveAttributes_SetIssueTerminationWarnings, METH_VARARGS},
    {"GetIssueTerminationWarnings", IntegralCurveAttributes_GetIssueTerminationWarnings, METH_VARARGS},
    {"SetIssueStepsizeWarnings", IntegralCurveAttributes_SetIssueStepsizeWarnings, METH_VARARGS},
    {"GetIssueStepsizeWarnings", IntegralCurveAttributes_GetIssueStepsizeWarnings, METH_VARARGS},
    {"SetIssueStiffnessWarnings", IntegralCurveAttributes_SetIssueStiffnessWarnings, METH_VARARGS},
    {"GetIssueStiffnessWarnings", IntegralCurveAttributes_GetIssueStiffnessWarnings, METH_VARARGS},
    {"SetIssueCriticalPointsWarnings", IntegralCurveAttributes_SetIssueCriticalPointsWarnings, METH_VARARGS},
    {"GetIssueCriticalPointsWarnings", IntegralCurveAttributes_GetIssueCriticalPointsWarnings, METH_VARARGS},
    {"SetCriticalPointThreshold", IntegralCurveAttributes_SetCriticalPointThreshold, METH_VARARGS},
    {"GetCriticalPointThreshold", IntegralCurveAttributes_GetCriticalPointThreshold, METH_VARARGS},
    {"SetCorrelationDistanceAngTol", IntegralCurveAttributes_SetCorrelationDistanceAngTol, METH_VARARGS},
    {"GetCorrelationDistanceAngTol", IntegralCurveAttributes_GetCorrelationDistanceAngTol, METH_VARARGS},
    {"SetCorrelationDistanceMinDistAbsolute", IntegralCurveAttributes_SetCorrelationDistanceMinDistAbsolute, METH_VARARGS},
    {"GetCorrelationDistanceMinDistAbsolute", IntegralCurveAttributes_GetCorrelationDistanceMinDistAbsolute, METH_VARARGS},
    {"SetCorrelationDistanceMinDistBBox", IntegralCurveAttributes_SetCorrelationDistanceMinDistBBox, METH_VARARGS},
    {"GetCorrelationDistanceMinDistBBox", IntegralCurveAttributes_GetCorrelationDistanceMinDistBBox, METH_VARARGS},
    {"SetCorrelationDistanceMinDistType", IntegralCurveAttributes_SetCorrelationDistanceMinDistType, METH_VARARGS},
    {"GetCorrelationDistanceMinDistType", IntegralCurveAttributes_GetCorrelationDistanceMinDistType, METH_VARARGS},
    {"SetSelection", IntegralCurveAttributes_SetSelection, METH_VARARGS},
    {"GetSelection", IntegralCurveAttributes_GetSelection, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
IntegralCurveAttributes_dealloc(PyObject *v)
{
   IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
IntegralCurveAttributes_compare(PyObject *v, PyObject *w)
{
    IntegralCurveAttributes *a = ((IntegralCurveAttributesObject *)v)->data;
    IntegralCurveAttributes *b = ((IntegralCurveAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyIntegralCurveAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "sourceType") == 0)
        return IntegralCurveAttributes_GetSourceType(self, NULL);
    if(strcmp(name, "SpecifiedPoint") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::SpecifiedPoint));
    if(strcmp(name, "PointList") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::PointList));
    if(strcmp(name, "SpecifiedLine") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::SpecifiedLine));
    if(strcmp(name, "Circle") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Circle));
    if(strcmp(name, "SpecifiedPlane") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::SpecifiedPlane));
    if(strcmp(name, "SpecifiedSphere") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::SpecifiedSphere));
    if(strcmp(name, "SpecifiedBox") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::SpecifiedBox));
    if(strcmp(name, "Selection") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Selection));
    if(strcmp(name, "FieldData") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::FieldData));

    if(strcmp(name, "pointSource") == 0)
        return IntegralCurveAttributes_GetPointSource(self, NULL);
    if(strcmp(name, "lineStart") == 0)
        return IntegralCurveAttributes_GetLineStart(self, NULL);
    if(strcmp(name, "lineEnd") == 0)
        return IntegralCurveAttributes_GetLineEnd(self, NULL);
    if(strcmp(name, "planeOrigin") == 0)
        return IntegralCurveAttributes_GetPlaneOrigin(self, NULL);
    if(strcmp(name, "planeNormal") == 0)
        return IntegralCurveAttributes_GetPlaneNormal(self, NULL);
    if(strcmp(name, "planeUpAxis") == 0)
        return IntegralCurveAttributes_GetPlaneUpAxis(self, NULL);
    if(strcmp(name, "radius") == 0)
        return IntegralCurveAttributes_GetRadius(self, NULL);
    if(strcmp(name, "sphereOrigin") == 0)
        return IntegralCurveAttributes_GetSphereOrigin(self, NULL);
    if(strcmp(name, "boxExtents") == 0)
        return IntegralCurveAttributes_GetBoxExtents(self, NULL);
    if(strcmp(name, "useWholeBox") == 0)
        return IntegralCurveAttributes_GetUseWholeBox(self, NULL);
    if(strcmp(name, "pointList") == 0)
        return IntegralCurveAttributes_GetPointList(self, NULL);
    if(strcmp(name, "fieldData") == 0)
        return IntegralCurveAttributes_GetFieldData(self, NULL);
    if(strcmp(name, "sampleDensity0") == 0)
        return IntegralCurveAttributes_GetSampleDensity0(self, NULL);
    if(strcmp(name, "sampleDensity1") == 0)
        return IntegralCurveAttributes_GetSampleDensity1(self, NULL);
    if(strcmp(name, "sampleDensity2") == 0)
        return IntegralCurveAttributes_GetSampleDensity2(self, NULL);
    if(strcmp(name, "dataValue") == 0)
        return IntegralCurveAttributes_GetDataValue(self, NULL);
    if(strcmp(name, "Solid") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Solid));
    if(strcmp(name, "SeedPointID") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::SeedPointID));
    if(strcmp(name, "Speed") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Speed));
    if(strcmp(name, "Vorticity") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Vorticity));
    if(strcmp(name, "ArcLength") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::ArcLength));
    if(strcmp(name, "TimeAbsolute") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::TimeAbsolute));
    if(strcmp(name, "TimeRelative") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::TimeRelative));
    if(strcmp(name, "AverageDistanceFromSeed") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::AverageDistanceFromSeed));
    if(strcmp(name, "CorrelationDistance") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::CorrelationDistance));
    if(strcmp(name, "ClosedCurve") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::ClosedCurve));
    if(strcmp(name, "Difference") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Difference));
    if(strcmp(name, "Variable") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Variable));

    if(strcmp(name, "dataVariable") == 0)
        return IntegralCurveAttributes_GetDataVariable(self, NULL);
    if(strcmp(name, "integrationDirection") == 0)
        return IntegralCurveAttributes_GetIntegrationDirection(self, NULL);
    if(strcmp(name, "Forward") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Forward));
    if(strcmp(name, "Backward") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Backward));
    if(strcmp(name, "Both") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Both));
    if(strcmp(name, "ForwardDirectionless") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::ForwardDirectionless));
    if(strcmp(name, "BackwardDirectionless") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::BackwardDirectionless));
    if(strcmp(name, "BothDirectionless") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::BothDirectionless));

    if(strcmp(name, "maxSteps") == 0)
        return IntegralCurveAttributes_GetMaxSteps(self, NULL);
    if(strcmp(name, "terminateByDistance") == 0)
        return IntegralCurveAttributes_GetTerminateByDistance(self, NULL);
    if(strcmp(name, "termDistance") == 0)
        return IntegralCurveAttributes_GetTermDistance(self, NULL);
    if(strcmp(name, "terminateByTime") == 0)
        return IntegralCurveAttributes_GetTerminateByTime(self, NULL);
    if(strcmp(name, "termTime") == 0)
        return IntegralCurveAttributes_GetTermTime(self, NULL);
    if(strcmp(name, "maxStepLength") == 0)
        return IntegralCurveAttributes_GetMaxStepLength(self, NULL);
    if(strcmp(name, "limitMaximumTimestep") == 0)
        return IntegralCurveAttributes_GetLimitMaximumTimestep(self, NULL);
    if(strcmp(name, "maxTimeStep") == 0)
        return IntegralCurveAttributes_GetMaxTimeStep(self, NULL);
    if(strcmp(name, "relTol") == 0)
        return IntegralCurveAttributes_GetRelTol(self, NULL);
    if(strcmp(name, "absTolSizeType") == 0)
        return IntegralCurveAttributes_GetAbsTolSizeType(self, NULL);
    if(strcmp(name, "Absolute") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Absolute));
    if(strcmp(name, "FractionOfBBox") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::FractionOfBBox));

    if(strcmp(name, "absTolAbsolute") == 0)
        return IntegralCurveAttributes_GetAbsTolAbsolute(self, NULL);
    if(strcmp(name, "absTolBBox") == 0)
        return IntegralCurveAttributes_GetAbsTolBBox(self, NULL);
    if(strcmp(name, "fieldType") == 0)
        return IntegralCurveAttributes_GetFieldType(self, NULL);
    if(strcmp(name, "Default") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Default));
    if(strcmp(name, "FlashField") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::FlashField));
    if(strcmp(name, "M3DC12DField") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::M3DC12DField));
    if(strcmp(name, "M3DC13DField") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::M3DC13DField));
    if(strcmp(name, "Nek5000Field") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Nek5000Field));
    if(strcmp(name, "NektarPPField") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::NektarPPField));
    if(strcmp(name, "NIMRODField") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::NIMRODField));

    if(strcmp(name, "fieldConstant") == 0)
        return IntegralCurveAttributes_GetFieldConstant(self, NULL);
    if(strcmp(name, "velocitySource") == 0)
        return IntegralCurveAttributes_GetVelocitySource(self, NULL);
    if(strcmp(name, "integrationType") == 0)
        return IntegralCurveAttributes_GetIntegrationType(self, NULL);
    if(strcmp(name, "Euler") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Euler));
    if(strcmp(name, "Leapfrog") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Leapfrog));
    if(strcmp(name, "DormandPrince") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::DormandPrince));
    if(strcmp(name, "AdamsBashforth") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::AdamsBashforth));
    if(strcmp(name, "RK4") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::RK4));
    if(strcmp(name, "M3DC12DIntegrator") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::M3DC12DIntegrator));

    if(strcmp(name, "parallelizationAlgorithmType") == 0)
        return IntegralCurveAttributes_GetParallelizationAlgorithmType(self, NULL);
    if(strcmp(name, "LoadOnDemand") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::LoadOnDemand));
    if(strcmp(name, "ParallelStaticDomains") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::ParallelStaticDomains));
    if(strcmp(name, "MasterSlave") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::MasterSlave));
    if(strcmp(name, "VisItSelects") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::VisItSelects));

    if(strcmp(name, "maxProcessCount") == 0)
        return IntegralCurveAttributes_GetMaxProcessCount(self, NULL);
    if(strcmp(name, "maxDomainCacheSize") == 0)
        return IntegralCurveAttributes_GetMaxDomainCacheSize(self, NULL);
    if(strcmp(name, "workGroupSize") == 0)
        return IntegralCurveAttributes_GetWorkGroupSize(self, NULL);
    if(strcmp(name, "pathlines") == 0)
        return IntegralCurveAttributes_GetPathlines(self, NULL);
    if(strcmp(name, "pathlinesOverrideStartingTimeFlag") == 0)
        return IntegralCurveAttributes_GetPathlinesOverrideStartingTimeFlag(self, NULL);
    if(strcmp(name, "pathlinesOverrideStartingTime") == 0)
        return IntegralCurveAttributes_GetPathlinesOverrideStartingTime(self, NULL);
    if(strcmp(name, "pathlinesPeriod") == 0)
        return IntegralCurveAttributes_GetPathlinesPeriod(self, NULL);
    if(strcmp(name, "pathlinesCMFE") == 0)
        return IntegralCurveAttributes_GetPathlinesCMFE(self, NULL);
    if(strcmp(name, "CONN_CMFE") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::CONN_CMFE));
    if(strcmp(name, "POS_CMFE") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::POS_CMFE));

    if(strcmp(name, "displayGeometry") == 0)
        return IntegralCurveAttributes_GetDisplayGeometry(self, NULL);
    if(strcmp(name, "Lines") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Lines));
    if(strcmp(name, "Tubes") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Tubes));
    if(strcmp(name, "Ribbons") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Ribbons));

    if(strcmp(name, "cleanupMethod") == 0)
        return IntegralCurveAttributes_GetCleanupMethod(self, NULL);
    if(strcmp(name, "NoCleanup") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::NoCleanup));
    if(strcmp(name, "Merge") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Merge));
    if(strcmp(name, "Before") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Before));
    if(strcmp(name, "After") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::After));

    if(strcmp(name, "cleanupThreshold") == 0)
        return IntegralCurveAttributes_GetCleanupThreshold(self, NULL);
    if(strcmp(name, "cropBeginFlag") == 0)
        return IntegralCurveAttributes_GetCropBeginFlag(self, NULL);
    if(strcmp(name, "cropBegin") == 0)
        return IntegralCurveAttributes_GetCropBegin(self, NULL);
    if(strcmp(name, "cropEndFlag") == 0)
        return IntegralCurveAttributes_GetCropEndFlag(self, NULL);
    if(strcmp(name, "cropEnd") == 0)
        return IntegralCurveAttributes_GetCropEnd(self, NULL);
    if(strcmp(name, "cropValue") == 0)
        return IntegralCurveAttributes_GetCropValue(self, NULL);
    if(strcmp(name, "Distance") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Distance));
    if(strcmp(name, "Time") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Time));
    if(strcmp(name, "StepNumber") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::StepNumber));

    if(strcmp(name, "sampleDistance0") == 0)
        return IntegralCurveAttributes_GetSampleDistance0(self, NULL);
    if(strcmp(name, "sampleDistance1") == 0)
        return IntegralCurveAttributes_GetSampleDistance1(self, NULL);
    if(strcmp(name, "sampleDistance2") == 0)
        return IntegralCurveAttributes_GetSampleDistance2(self, NULL);
    if(strcmp(name, "fillInterior") == 0)
        return IntegralCurveAttributes_GetFillInterior(self, NULL);
    if(strcmp(name, "randomSamples") == 0)
        return IntegralCurveAttributes_GetRandomSamples(self, NULL);
    if(strcmp(name, "randomSeed") == 0)
        return IntegralCurveAttributes_GetRandomSeed(self, NULL);
    if(strcmp(name, "numberOfRandomSamples") == 0)
        return IntegralCurveAttributes_GetNumberOfRandomSamples(self, NULL);
    if(strcmp(name, "issueAdvectionWarnings") == 0)
        return IntegralCurveAttributes_GetIssueAdvectionWarnings(self, NULL);
    if(strcmp(name, "issueBoundaryWarnings") == 0)
        return IntegralCurveAttributes_GetIssueBoundaryWarnings(self, NULL);
    if(strcmp(name, "issueTerminationWarnings") == 0)
        return IntegralCurveAttributes_GetIssueTerminationWarnings(self, NULL);
    if(strcmp(name, "issueStepsizeWarnings") == 0)
        return IntegralCurveAttributes_GetIssueStepsizeWarnings(self, NULL);
    if(strcmp(name, "issueStiffnessWarnings") == 0)
        return IntegralCurveAttributes_GetIssueStiffnessWarnings(self, NULL);
    if(strcmp(name, "issueCriticalPointsWarnings") == 0)
        return IntegralCurveAttributes_GetIssueCriticalPointsWarnings(self, NULL);
    if(strcmp(name, "criticalPointThreshold") == 0)
        return IntegralCurveAttributes_GetCriticalPointThreshold(self, NULL);
    if(strcmp(name, "correlationDistanceAngTol") == 0)
        return IntegralCurveAttributes_GetCorrelationDistanceAngTol(self, NULL);
    if(strcmp(name, "correlationDistanceMinDistAbsolute") == 0)
        return IntegralCurveAttributes_GetCorrelationDistanceMinDistAbsolute(self, NULL);
    if(strcmp(name, "correlationDistanceMinDistBBox") == 0)
        return IntegralCurveAttributes_GetCorrelationDistanceMinDistBBox(self, NULL);
    if(strcmp(name, "correlationDistanceMinDistType") == 0)
        return IntegralCurveAttributes_GetCorrelationDistanceMinDistType(self, NULL);
    if(strcmp(name, "Absolute") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::Absolute));
    if(strcmp(name, "FractionOfBBox") == 0)
        return PyInt_FromLong(long(IntegralCurveAttributes::FractionOfBBox));

    if(strcmp(name, "selection") == 0)
        return IntegralCurveAttributes_GetSelection(self, NULL);

    return Py_FindMethod(PyIntegralCurveAttributes_methods, self, name);
}

int
PyIntegralCurveAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "sourceType") == 0)
        obj = IntegralCurveAttributes_SetSourceType(self, tuple);
    else if(strcmp(name, "pointSource") == 0)
        obj = IntegralCurveAttributes_SetPointSource(self, tuple);
    else if(strcmp(name, "lineStart") == 0)
        obj = IntegralCurveAttributes_SetLineStart(self, tuple);
    else if(strcmp(name, "lineEnd") == 0)
        obj = IntegralCurveAttributes_SetLineEnd(self, tuple);
    else if(strcmp(name, "planeOrigin") == 0)
        obj = IntegralCurveAttributes_SetPlaneOrigin(self, tuple);
    else if(strcmp(name, "planeNormal") == 0)
        obj = IntegralCurveAttributes_SetPlaneNormal(self, tuple);
    else if(strcmp(name, "planeUpAxis") == 0)
        obj = IntegralCurveAttributes_SetPlaneUpAxis(self, tuple);
    else if(strcmp(name, "radius") == 0)
        obj = IntegralCurveAttributes_SetRadius(self, tuple);
    else if(strcmp(name, "sphereOrigin") == 0)
        obj = IntegralCurveAttributes_SetSphereOrigin(self, tuple);
    else if(strcmp(name, "boxExtents") == 0)
        obj = IntegralCurveAttributes_SetBoxExtents(self, tuple);
    else if(strcmp(name, "useWholeBox") == 0)
        obj = IntegralCurveAttributes_SetUseWholeBox(self, tuple);
    else if(strcmp(name, "pointList") == 0)
        obj = IntegralCurveAttributes_SetPointList(self, tuple);
    else if(strcmp(name, "fieldData") == 0)
        obj = IntegralCurveAttributes_SetFieldData(self, tuple);
    else if(strcmp(name, "sampleDensity0") == 0)
        obj = IntegralCurveAttributes_SetSampleDensity0(self, tuple);
    else if(strcmp(name, "sampleDensity1") == 0)
        obj = IntegralCurveAttributes_SetSampleDensity1(self, tuple);
    else if(strcmp(name, "sampleDensity2") == 0)
        obj = IntegralCurveAttributes_SetSampleDensity2(self, tuple);
    else if(strcmp(name, "dataValue") == 0)
        obj = IntegralCurveAttributes_SetDataValue(self, tuple);
    else if(strcmp(name, "dataVariable") == 0)
        obj = IntegralCurveAttributes_SetDataVariable(self, tuple);
    else if(strcmp(name, "integrationDirection") == 0)
        obj = IntegralCurveAttributes_SetIntegrationDirection(self, tuple);
    else if(strcmp(name, "maxSteps") == 0)
        obj = IntegralCurveAttributes_SetMaxSteps(self, tuple);
    else if(strcmp(name, "terminateByDistance") == 0)
        obj = IntegralCurveAttributes_SetTerminateByDistance(self, tuple);
    else if(strcmp(name, "termDistance") == 0)
        obj = IntegralCurveAttributes_SetTermDistance(self, tuple);
    else if(strcmp(name, "terminateByTime") == 0)
        obj = IntegralCurveAttributes_SetTerminateByTime(self, tuple);
    else if(strcmp(name, "termTime") == 0)
        obj = IntegralCurveAttributes_SetTermTime(self, tuple);
    else if(strcmp(name, "maxStepLength") == 0)
        obj = IntegralCurveAttributes_SetMaxStepLength(self, tuple);
    else if(strcmp(name, "limitMaximumTimestep") == 0)
        obj = IntegralCurveAttributes_SetLimitMaximumTimestep(self, tuple);
    else if(strcmp(name, "maxTimeStep") == 0)
        obj = IntegralCurveAttributes_SetMaxTimeStep(self, tuple);
    else if(strcmp(name, "relTol") == 0)
        obj = IntegralCurveAttributes_SetRelTol(self, tuple);
    else if(strcmp(name, "absTolSizeType") == 0)
        obj = IntegralCurveAttributes_SetAbsTolSizeType(self, tuple);
    else if(strcmp(name, "absTolAbsolute") == 0)
        obj = IntegralCurveAttributes_SetAbsTolAbsolute(self, tuple);
    else if(strcmp(name, "absTolBBox") == 0)
        obj = IntegralCurveAttributes_SetAbsTolBBox(self, tuple);
    else if(strcmp(name, "fieldType") == 0)
        obj = IntegralCurveAttributes_SetFieldType(self, tuple);
    else if(strcmp(name, "fieldConstant") == 0)
        obj = IntegralCurveAttributes_SetFieldConstant(self, tuple);
    else if(strcmp(name, "velocitySource") == 0)
        obj = IntegralCurveAttributes_SetVelocitySource(self, tuple);
    else if(strcmp(name, "integrationType") == 0)
        obj = IntegralCurveAttributes_SetIntegrationType(self, tuple);
    else if(strcmp(name, "parallelizationAlgorithmType") == 0)
        obj = IntegralCurveAttributes_SetParallelizationAlgorithmType(self, tuple);
    else if(strcmp(name, "maxProcessCount") == 0)
        obj = IntegralCurveAttributes_SetMaxProcessCount(self, tuple);
    else if(strcmp(name, "maxDomainCacheSize") == 0)
        obj = IntegralCurveAttributes_SetMaxDomainCacheSize(self, tuple);
    else if(strcmp(name, "workGroupSize") == 0)
        obj = IntegralCurveAttributes_SetWorkGroupSize(self, tuple);
    else if(strcmp(name, "pathlines") == 0)
        obj = IntegralCurveAttributes_SetPathlines(self, tuple);
    else if(strcmp(name, "pathlinesOverrideStartingTimeFlag") == 0)
        obj = IntegralCurveAttributes_SetPathlinesOverrideStartingTimeFlag(self, tuple);
    else if(strcmp(name, "pathlinesOverrideStartingTime") == 0)
        obj = IntegralCurveAttributes_SetPathlinesOverrideStartingTime(self, tuple);
    else if(strcmp(name, "pathlinesPeriod") == 0)
        obj = IntegralCurveAttributes_SetPathlinesPeriod(self, tuple);
    else if(strcmp(name, "pathlinesCMFE") == 0)
        obj = IntegralCurveAttributes_SetPathlinesCMFE(self, tuple);
    else if(strcmp(name, "displayGeometry") == 0)
        obj = IntegralCurveAttributes_SetDisplayGeometry(self, tuple);
    else if(strcmp(name, "cleanupMethod") == 0)
        obj = IntegralCurveAttributes_SetCleanupMethod(self, tuple);
    else if(strcmp(name, "cleanupThreshold") == 0)
        obj = IntegralCurveAttributes_SetCleanupThreshold(self, tuple);
    else if(strcmp(name, "cropBeginFlag") == 0)
        obj = IntegralCurveAttributes_SetCropBeginFlag(self, tuple);
    else if(strcmp(name, "cropBegin") == 0)
        obj = IntegralCurveAttributes_SetCropBegin(self, tuple);
    else if(strcmp(name, "cropEndFlag") == 0)
        obj = IntegralCurveAttributes_SetCropEndFlag(self, tuple);
    else if(strcmp(name, "cropEnd") == 0)
        obj = IntegralCurveAttributes_SetCropEnd(self, tuple);
    else if(strcmp(name, "cropValue") == 0)
        obj = IntegralCurveAttributes_SetCropValue(self, tuple);
    else if(strcmp(name, "sampleDistance0") == 0)
        obj = IntegralCurveAttributes_SetSampleDistance0(self, tuple);
    else if(strcmp(name, "sampleDistance1") == 0)
        obj = IntegralCurveAttributes_SetSampleDistance1(self, tuple);
    else if(strcmp(name, "sampleDistance2") == 0)
        obj = IntegralCurveAttributes_SetSampleDistance2(self, tuple);
    else if(strcmp(name, "fillInterior") == 0)
        obj = IntegralCurveAttributes_SetFillInterior(self, tuple);
    else if(strcmp(name, "randomSamples") == 0)
        obj = IntegralCurveAttributes_SetRandomSamples(self, tuple);
    else if(strcmp(name, "randomSeed") == 0)
        obj = IntegralCurveAttributes_SetRandomSeed(self, tuple);
    else if(strcmp(name, "numberOfRandomSamples") == 0)
        obj = IntegralCurveAttributes_SetNumberOfRandomSamples(self, tuple);
    else if(strcmp(name, "issueAdvectionWarnings") == 0)
        obj = IntegralCurveAttributes_SetIssueAdvectionWarnings(self, tuple);
    else if(strcmp(name, "issueBoundaryWarnings") == 0)
        obj = IntegralCurveAttributes_SetIssueBoundaryWarnings(self, tuple);
    else if(strcmp(name, "issueTerminationWarnings") == 0)
        obj = IntegralCurveAttributes_SetIssueTerminationWarnings(self, tuple);
    else if(strcmp(name, "issueStepsizeWarnings") == 0)
        obj = IntegralCurveAttributes_SetIssueStepsizeWarnings(self, tuple);
    else if(strcmp(name, "issueStiffnessWarnings") == 0)
        obj = IntegralCurveAttributes_SetIssueStiffnessWarnings(self, tuple);
    else if(strcmp(name, "issueCriticalPointsWarnings") == 0)
        obj = IntegralCurveAttributes_SetIssueCriticalPointsWarnings(self, tuple);
    else if(strcmp(name, "criticalPointThreshold") == 0)
        obj = IntegralCurveAttributes_SetCriticalPointThreshold(self, tuple);
    else if(strcmp(name, "correlationDistanceAngTol") == 0)
        obj = IntegralCurveAttributes_SetCorrelationDistanceAngTol(self, tuple);
    else if(strcmp(name, "correlationDistanceMinDistAbsolute") == 0)
        obj = IntegralCurveAttributes_SetCorrelationDistanceMinDistAbsolute(self, tuple);
    else if(strcmp(name, "correlationDistanceMinDistBBox") == 0)
        obj = IntegralCurveAttributes_SetCorrelationDistanceMinDistBBox(self, tuple);
    else if(strcmp(name, "correlationDistanceMinDistType") == 0)
        obj = IntegralCurveAttributes_SetCorrelationDistanceMinDistType(self, tuple);
    else if(strcmp(name, "selection") == 0)
        obj = IntegralCurveAttributes_SetSelection(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
IntegralCurveAttributes_print(PyObject *v, FILE *fp, int flags)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)v;
    fprintf(fp, "%s", PyIntegralCurveAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
IntegralCurveAttributes_str(PyObject *v)
{
    IntegralCurveAttributesObject *obj = (IntegralCurveAttributesObject *)v;
    return PyString_FromString(PyIntegralCurveAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *IntegralCurveAttributes_Purpose = "Attributes for the IntegralCurve";
#else
static char *IntegralCurveAttributes_Purpose = "Attributes for the IntegralCurve";
#endif

//
// The type description structure
//
static PyTypeObject IntegralCurveAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "IntegralCurveAttributes",                    // tp_name
    sizeof(IntegralCurveAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)IntegralCurveAttributes_dealloc,  // tp_dealloc
    (printfunc)IntegralCurveAttributes_print,     // tp_print
    (getattrfunc)PyIntegralCurveAttributes_getattr, // tp_getattr
    (setattrfunc)PyIntegralCurveAttributes_setattr, // tp_setattr
    (cmpfunc)IntegralCurveAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)IntegralCurveAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    IntegralCurveAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static IntegralCurveAttributes *defaultAtts = 0;
static IntegralCurveAttributes *currentAtts = 0;

static PyObject *
NewIntegralCurveAttributes(int useCurrent)
{
    IntegralCurveAttributesObject *newObject;
    newObject = PyObject_NEW(IntegralCurveAttributesObject, &IntegralCurveAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new IntegralCurveAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new IntegralCurveAttributes(*defaultAtts);
    else
        newObject->data = new IntegralCurveAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapIntegralCurveAttributes(const IntegralCurveAttributes *attr)
{
    IntegralCurveAttributesObject *newObject;
    newObject = PyObject_NEW(IntegralCurveAttributesObject, &IntegralCurveAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (IntegralCurveAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
IntegralCurveAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewIntegralCurveAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef IntegralCurveAttributesMethods[] = {
    {"IntegralCurveAttributes", IntegralCurveAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *IntegralCurveAttributesObserver = 0;

std::string
PyIntegralCurveAttributes_GetLogString()
{
    std::string s("IntegralCurveAtts = IntegralCurveAttributes()\n");
    if(currentAtts != 0)
        s += PyIntegralCurveAttributes_ToString(currentAtts, "IntegralCurveAtts.");
    return s;
}

static void
PyIntegralCurveAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("IntegralCurveAtts = IntegralCurveAttributes()\n");
        s += PyIntegralCurveAttributes_ToString(currentAtts, "IntegralCurveAtts.");
        cb(s);
    }
}

void
PyIntegralCurveAttributes_StartUp(IntegralCurveAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyIntegralCurveAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(IntegralCurveAttributesObserver == 0)
    {
        IntegralCurveAttributesObserver = new ObserverToCallback(subj,
            PyIntegralCurveAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyIntegralCurveAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete IntegralCurveAttributesObserver;
    IntegralCurveAttributesObserver = 0;
}

PyMethodDef *
PyIntegralCurveAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return IntegralCurveAttributesMethods;
}

bool
PyIntegralCurveAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &IntegralCurveAttributesType);
}

IntegralCurveAttributes *
PyIntegralCurveAttributes_FromPyObject(PyObject *obj)
{
    IntegralCurveAttributesObject *obj2 = (IntegralCurveAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyIntegralCurveAttributes_New()
{
    return NewIntegralCurveAttributes(0);
}

PyObject *
PyIntegralCurveAttributes_Wrap(const IntegralCurveAttributes *attr)
{
    return WrapIntegralCurveAttributes(attr);
}

void
PyIntegralCurveAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    IntegralCurveAttributesObject *obj2 = (IntegralCurveAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyIntegralCurveAttributes_SetDefaults(const IntegralCurveAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new IntegralCurveAttributes(*atts);
}

