// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  IndexSelectScriptingPluginInfo.C
// ************************************************************************* //
#include <PyIndexSelectAttributes.h>
#include <IndexSelectPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(IndexSelect,Scripting)

// ****************************************************************************
// Method: IndexSelectScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
IndexSelectScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyIndexSelectAttributes_StartUp((IndexSelectAttributes *)subj, data);
}

// ****************************************************************************
// Method: IndexSelectScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
IndexSelectScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyIndexSelectAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: IndexSelectScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is IndexSelect plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
IndexSelectScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyIndexSelectAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: IndexSelectScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
IndexSelectScriptingPluginInfo::GetLogString()
{
    std::string s(PyIndexSelectAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: IndexSelectScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
IndexSelectScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyIndexSelectAttributes_SetDefaults((const IndexSelectAttributes *)atts);
}
