// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: IndexSelectCommonPluginInfo.C
// ****************************************************************************

#include <IndexSelectPluginInfo.h>
#include <IndexSelectAttributes.h>

// ****************************************************************************
//  Method: IndexSelectCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
IndexSelectCommonPluginInfo::AllocAttributes()
{
    return new IndexSelectAttributes;
}

// ****************************************************************************
//  Method: IndexSelectCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a IndexSelect attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
IndexSelectCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((IndexSelectAttributes *) to) = *((IndexSelectAttributes *) from);
}
