// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtFluxFilter.h
// ************************************************************************* //

#ifndef AVT_Flux_FILTER_H
#define AVT_Flux_FILTER_H


#include <avtPluginFilter.h>
#include <avtDeferExpressionBaseFilter.h>
#include <FluxAttributes.h>


class vtkDataSet;


// ****************************************************************************
//  Class: avtFluxFilter
//
//  Purpose:
//      A plugin operator for Flux.
//
//  Programmer: hchilds -- generated by xml2avt
//  Creation:   Thu Sep 23 14:25:44 PST 2010
//
// ****************************************************************************

class avtFluxFilter : virtual public avtPluginFilter,
                               virtual public avtDeferExpressionBaseFilter
{
  public:
                         avtFluxFilter();
    virtual             ~avtFluxFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtFluxFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Flux"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    FluxAttributes            atts;
    std::string               varname;

    virtual void              InferVariableNameFromContract(avtContract_p);
    virtual void              GetCustomExpressions(std::vector<Expression> &);
    virtual void              GetVariablesToEvaluate(std::vector<std::string> &);
};


#endif


