// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtFluxFilter.C
// ************************************************************************* //

#include <avtFluxFilter.h>

#include <Expression.h>
#include <ExpressionList.h>
#include <ParsingExprList.h>


// ****************************************************************************
//  Method: avtFluxFilter constructor
//
//  Programmer: hchilds -- generated by xml2avt
//  Creation:   Thu Sep 23 14:25:44 PST 2010
//
// ****************************************************************************

avtFluxFilter::avtFluxFilter()
{
}


// ****************************************************************************
//  Method: avtFluxFilter destructor
//
//  Programmer: hchilds -- generated by xml2avt
//  Creation:   Thu Sep 23 14:25:44 PST 2010
//
//  Modifications:
//
// ****************************************************************************

avtFluxFilter::~avtFluxFilter()
{
}


// ****************************************************************************
//  Method:  avtFluxFilter::Create
//
//  Programmer: hchilds -- generated by xml2avt
//  Creation:   Thu Sep 23 14:25:44 PST 2010
//
// ****************************************************************************

avtFilter *
avtFluxFilter::Create()
{
    return new avtFluxFilter();
}


// ****************************************************************************
//  Method:      avtFluxFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: hchilds -- generated by xml2avt
//  Creation:   Thu Sep 23 14:25:44 PST 2010
//
// ****************************************************************************

void
avtFluxFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const FluxAttributes*)a;
}


// ****************************************************************************
//  Method: avtFluxFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtFluxFilter with the given
//      parameters would result in an equivalent avtFluxFilter.
//
//  Programmer: hchilds -- generated by xml2avt
//  Creation:   Thu Sep 23 14:25:44 PST 2010
//
// ****************************************************************************

bool
avtFluxFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(FluxAttributes*)a);
}


// ****************************************************************************
//  Method: avtFluxField::InferVariableNameFromContract
//
//  Purpose:
//      Studies the contract and determines the name of the variable we
//      are supposed to produce.
//
//  Programmer: Hank Childs
//  Creation:   September 24, 2010
//
// ****************************************************************************

void
avtFluxFilter::InferVariableNameFromContract(avtContract_p c)
{
    avtDataRequest_p in_dr = c->GetDataRequest();

    bool foundIt = false;
    if (strncmp(in_dr->GetVariable(), "operators/Flux/",
                strlen("operators/Flux/")) == 0)
    {
        foundIt = true;
        if (atts.GetFlowField() == "default")
        {
             EXCEPTION1(VisItException, "You can't set the flow field as \"default\" "
                        "since the default field is not a vector.");
        }
        if (atts.GetWeight() && atts.GetWeightField() == "default")
        {
             EXCEPTION1(VisItException, "You can't set the weighting field as \"default\" "
                        "since that would lead to a recursive definition.");
        }
        varname = in_dr->GetVariable()+strlen("operators/Flux/");
    }

    if (!foundIt)
    {
        std::vector<CharStrRef>   vars2nd = in_dr->GetSecondaryVariablesWithoutDuplicates();
        for (size_t i = 0 ; i < vars2nd.size() ; i++)
        if (strncmp(*(vars2nd[i]), "operators/Flux/",
                    strlen("operators/Flux/")) == 0)
        {
            foundIt = true;
            varname = *(vars2nd[i])+strlen("operators/Flux/");
        }
    }

    if (!foundIt)
    {
        EXCEPTION1(VisItException, "Unable to determine variable name from contract");
    }
}


// ****************************************************************************
//  Method: avtFluxFilter::GetCustomExpressions
//
//  Purpose:
//      Gets the expression definitions that should be used when executing
//      this filter.
//
//  Programmer: Hank Childs
//  Creation:   September 24, 2010
//
// ****************************************************************************

void 
avtFluxFilter::GetCustomExpressions(std::vector<Expression> &elist)
{
    Expression exp;
    char fullname[1024];
    snprintf(fullname, 1024, "operators/Flux/%s", varname.c_str());
    exp.SetName(fullname);
    char defn[1024];
    if (atts.GetWeight())
        snprintf(defn, 1024, "dot(cell_surface_normal(%s), %s)*%s", 
                 varname.c_str(), atts.GetFlowField().c_str(), atts.GetWeightField().c_str());
    else
        snprintf(defn, 1024, "dot(cell_surface_normal(%s), %s)", 
                 varname.c_str(), atts.GetFlowField().c_str());
    exp.SetDefinition(defn);
    exp.SetType(Expression::ScalarMeshVar);
    elist.push_back(exp);
}


// ****************************************************************************
//  Method: avtFluxFilter::GetVariableToEvaluated
//
//  Purpose:
//      Gets the expressions that should be evaluated when this filter
//      executes.
//
//  Programmer: Hank Childs
//  Creation:   September 24, 2010
//
// ****************************************************************************

void
avtFluxFilter::GetVariablesToEvaluate(std::vector<std::string> &list)
{
    char fullname[1024];
    snprintf(fullname, 1024, "operators/Flux/%s", varname.c_str());
    list.push_back(fullname);
}


