// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisFluxWindow.h"

#include <FluxAttributes.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QvisVariableButton.h>


// ****************************************************************************
// Method: QvisFluxWindow::QvisFluxWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisFluxWindow::QvisFluxWindow(const int type,
                         FluxAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisFluxWindow::~QvisFluxWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisFluxWindow::~QvisFluxWindow()
{
}


// ****************************************************************************
// Method: QvisFluxWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisFluxWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    flowFieldLabel = new QLabel(tr("Flow field"), central);
    mainLayout->addWidget(flowFieldLabel,0,0);
    int flowFieldMask = QvisVariableButton::Vectors;
    flowField = new QvisVariableButton(true, true, true, flowFieldMask, central);
    connect(flowField, SIGNAL(activated(const QString&)),
            this, SLOT(flowFieldChanged(const QString&)));
    mainLayout->addWidget(flowField, 0,1);

    weight = new QCheckBox(tr("Multiply dot product by a scalar variable?"), central);
    connect(weight, SIGNAL(toggled(bool)),
            this, SLOT(weightChanged(bool)));
    mainLayout->addWidget(weight, 1,0);

    weightFieldLabel = new QLabel(tr("Weight field"), central);
    mainLayout->addWidget(weightFieldLabel,2,0);
    int weightFieldMask = QvisVariableButton::Scalars;
    weightField = new QvisVariableButton(true, true, true, weightFieldMask, central);
    connect(weightField, SIGNAL(activated(const QString&)),
            this, SLOT(weightFieldChanged(const QString&)));
    mainLayout->addWidget(weightField, 2,1);

}


// ****************************************************************************
// Method: QvisFluxWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisFluxWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case FluxAttributes::ID_flowField:
            flowField->blockSignals(true);
            flowField->setText(QString(atts->GetFlowField().c_str()));
            flowField->blockSignals(false);
            break;
          case FluxAttributes::ID_weight:
            if (atts->GetWeight() == true)
            {
                weightField->setEnabled(true);
                if(weightFieldLabel)
                    weightFieldLabel->setEnabled(true);
            }
            else
            {
                weightField->setEnabled(false);
                if(weightFieldLabel)
                    weightFieldLabel->setEnabled(false);
            }
            weight->blockSignals(true);
            weight->setChecked(atts->GetWeight());
            weight->blockSignals(false);
            break;
          case FluxAttributes::ID_weightField:
            weightField->blockSignals(true);
            weightField->setText(QString(atts->GetWeightField().c_str()));
            weightField->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisFluxWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisFluxWindow::GetCurrentValues(int which_widget)
{
}


//
// Qt Slot functions
//


void
QvisFluxWindow::flowFieldChanged(const QString &varName)
{
    atts->SetFlowField(varName.toStdString());
    SetUpdate(false);
    Apply();
}


void
QvisFluxWindow::weightChanged(bool val)
{
    atts->SetWeight(val);
    Apply();
}


void
QvisFluxWindow::weightFieldChanged(const QString &varName)
{
    atts->SetWeightField(varName.toStdString());
    SetUpdate(false);
    Apply();
}


