// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: FluxCommonPluginInfo.C
// ****************************************************************************

#include <FluxPluginInfo.h>
#include <FluxAttributes.h>

#include <Expression.h>
#include <ExpressionList.h>
#include <avtDatabaseMetaData.h>
#include <avtMeshMetaData.h>

// ****************************************************************************
//  Method: FluxCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
FluxCommonPluginInfo::AllocAttributes()
{
    return new FluxAttributes;
}

// ****************************************************************************
//  Method: FluxCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Flux attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
FluxCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((FluxAttributes *) to) = *((FluxAttributes *) from);
}

// ****************************************************************************
//  Method: FluxCommonPluginInfo::GetCreatedExpressions
//
//  Purpose:
//      Gets the expressions created by this operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

ExpressionList *
FluxCommonPluginInfo::GetCreatedExpressions(const avtDatabaseMetaData *md) const
{
    char name[1024], defn[1024];
    ExpressionList *el = new ExpressionList;
    int numMeshes = md->GetNumMeshes();
    for (int i = 0; i < numMeshes; i++)
    {
        const avtMeshMetaData *mmd = md->GetMesh(i);
        if (mmd->hideFromGUI || !mmd->validVariable)
            continue;
        {
            Expression e2;
            sprintf(name, "operators/Flux/%s", mmd->name.c_str());
            e2.SetName(name);
            e2.SetType(Expression::ScalarMeshVar);
            e2.SetFromOperator(true);
            e2.SetOperatorName("Flux");
            sprintf(defn, "cell_constant(<%s>, 0.)", mmd->name.c_str());
            e2.SetDefinition(defn);
            el->AddExpressions(e2);
        }
    }
    return el;
}

