// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: FluxAttributes
//
// Purpose:
//    Attributes for Flux operator
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class FluxAttributes extends AttributeSubject implements Plugin
{
    private static int FluxAttributes_numAdditionalAtts = 3;

    public FluxAttributes()
    {
        super(FluxAttributes_numAdditionalAtts);

        flowField = new String("");
        weight = false;
        weightField = new String("");
    }

    public FluxAttributes(int nMoreFields)
    {
        super(FluxAttributes_numAdditionalAtts + nMoreFields);

        flowField = new String("");
        weight = false;
        weightField = new String("");
    }

    public FluxAttributes(FluxAttributes obj)
    {
        super(obj);

        flowField = new String(obj.flowField);
        weight = obj.weight;
        weightField = new String(obj.weightField);

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return FluxAttributes_numAdditionalAtts;
    }

    public boolean equals(FluxAttributes obj)
    {
        // Create the return value
        return ((flowField.equals(obj.flowField)) &&
                (weight == obj.weight) &&
                (weightField.equals(obj.weightField)));
    }

    public String GetName() { return "Flux"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetFlowField(String flowField_)
    {
        flowField = flowField_;
        Select(0);
    }

    public void SetWeight(boolean weight_)
    {
        weight = weight_;
        Select(1);
    }

    public void SetWeightField(String weightField_)
    {
        weightField = weightField_;
        Select(2);
    }

    // Property getting methods
    public String  GetFlowField() { return flowField; }
    public boolean GetWeight() { return weight; }
    public String  GetWeightField() { return weightField; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteString(flowField);
        if(WriteSelect(1, buf))
            buf.WriteBool(weight);
        if(WriteSelect(2, buf))
            buf.WriteString(weightField);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetFlowField(buf.ReadString());
            break;
        case 1:
            SetWeight(buf.ReadBool());
            break;
        case 2:
            SetWeightField(buf.ReadString());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + stringToString("flowField", flowField, indent) + "\n";
        str = str + boolToString("weight", weight, indent) + "\n";
        str = str + stringToString("weightField", weightField, indent) + "\n";
        return str;
    }


    // Attributes
    private String  flowField;
    private boolean weight;
    private String  weightField;
}

