// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISFIVEFOLDTETSUBDIVISIONWINDOW_H
#define QVISFIVEFOLDTETSUBDIVISIONWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class FiveFoldTetSubdivisionAttributes;
class QLabel;
class QCheckBox;
class QLineEdit;
class QvisVariableButton;

// ****************************************************************************
// Class: QvisFiveFoldTetSubdivisionWindow
//
// Purpose:
//    Defines QvisFiveFoldTetSubdivisionWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisFiveFoldTetSubdivisionWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisFiveFoldTetSubdivisionWindow(const int type,
                         FiveFoldTetSubdivisionAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisFiveFoldTetSubdivisionWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void oddParityHasSixNeighborhoodChanged(bool val);
    void addComponentInformationChanged(bool val);
    void idVarChanged(const QString &varName);
    void valueVarChanged(const QString &varName);
    void contourTreeFilenameProcessText();
    void isovalueProcessText();
    void selectedIdsProcessText();
    void highlightedIdsProcessText();
  private:
    QCheckBox *oddParityHasSixNeighborhood;
    QCheckBox *addComponentInformation;
    QvisVariableButton *idVar;
    QvisVariableButton *valueVar;
    QLineEdit *contourTreeFilename;
    QLineEdit *isovalue;
    QLineEdit *selectedIds;
    QLineEdit *highlightedIds;
    QLabel *idVarLabel;
    QLabel *valueVarLabel;
    QLabel *contourTreeFilenameLabel;
    QLabel *isovalueLabel;
    QLabel *selectedIdsLabel;
    QLabel *highlightedIdsLabel;

    FiveFoldTetSubdivisionAttributes *atts;
};



#endif
