// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: FiveFoldTetSubdivisionViewerEnginePluginInfo.C
// ****************************************************************************

#include <FiveFoldTetSubdivisionPluginInfo.h>
#include <FiveFoldTetSubdivisionAttributes.h>

//
// Storage for static data elements.
//
FiveFoldTetSubdivisionAttributes *FiveFoldTetSubdivisionViewerEnginePluginInfo::clientAtts = NULL;
FiveFoldTetSubdivisionAttributes *FiveFoldTetSubdivisionViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  FiveFoldTetSubdivisionViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
FiveFoldTetSubdivisionViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (FiveFoldTetSubdivisionViewerEnginePluginInfo::clientAtts == NULL)
    {
        FiveFoldTetSubdivisionViewerEnginePluginInfo::clientAtts  = new FiveFoldTetSubdivisionAttributes;
        FiveFoldTetSubdivisionViewerEnginePluginInfo::defaultAtts = new FiveFoldTetSubdivisionAttributes;
    }
}

// ****************************************************************************
//  Method: FiveFoldTetSubdivisionViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
FiveFoldTetSubdivisionViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: FiveFoldTetSubdivisionViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
FiveFoldTetSubdivisionViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: FiveFoldTetSubdivisionViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
FiveFoldTetSubdivisionViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(FiveFoldTetSubdivisionAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: FiveFoldTetSubdivisionViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
FiveFoldTetSubdivisionViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(FiveFoldTetSubdivisionAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: FiveFoldTetSubdivisionViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
FiveFoldTetSubdivisionViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(FiveFoldTetSubdivisionAttributes*)atts = *defaultAtts;
    else
        *(FiveFoldTetSubdivisionAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: FiveFoldTetSubdivisionViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
FiveFoldTetSubdivisionViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: FiveFoldTetSubdivisionViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
FiveFoldTetSubdivisionViewerEnginePluginInfo::GetMenuName() const
{
    return "Five Fold Tet Subdvision";
}

