// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: FiveFoldTetSubdivisionPluginInfo.h
// ****************************************************************************

#ifndef FIVEFOLDTETSUBDIVISION_PLUGIN_INFO_H
#define FIVEFOLDTETSUBDIVISION_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class FiveFoldTetSubdivisionAttributes;

// ****************************************************************************
//  Class: FiveFoldTetSubdivisionPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an FiveFoldTetSubdivision operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class FiveFoldTetSubdivisionGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class FiveFoldTetSubdivisionCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual FiveFoldTetSubdivisionGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class FiveFoldTetSubdivisionGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual FiveFoldTetSubdivisionCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class FiveFoldTetSubdivisionViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual FiveFoldTetSubdivisionCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static FiveFoldTetSubdivisionAttributes *defaultAtts;
    static FiveFoldTetSubdivisionAttributes *clientAtts;
};

class FiveFoldTetSubdivisionViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual FiveFoldTetSubdivisionViewerEnginePluginInfo
{
  public:
};

class FiveFoldTetSubdivisionEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual FiveFoldTetSubdivisionViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class FiveFoldTetSubdivisionScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual FiveFoldTetSubdivisionCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
