// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtFFTFilter.h
// ************************************************************************* //

#ifndef AVT_FFT_FILTER_H
#define AVT_FFT_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <FFTAttributes.h>

class vtkRectilinearGrid;


// ****************************************************************************
//  Class: avtFFTFilter
//
//  Purpose:
//      A plugin operator for FFT.
//
//  Programmer: bala -- generated by xml2avt
//  Creation:   Thu Aug 18 09:28:06 PDT 2011
//
//  Modifications:
//    Eric Brugger, Mon Jul 28 15:22:04 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtFFTFilter : public avtPluginDataTreeIterator
{
  public:
                         avtFFTFilter();
    virtual             ~avtFFTFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtFFTFilter"; };
    virtual const char  *GetDescription(void)
                             { return "FFT"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    FFTAttributes   atts;

    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);
    virtual void         UpdateDataObjectInfo(void);

  private: 
    vtkRectilinearGrid* ComputeFFT(std::vector<double>* data, long nData, double dt);
    void    Fourier(double* data, long nn, long isign);
    vtkRectilinearGrid* PopulateRGrid(std::vector<double>* freqs, double* fftData, long nFFThalf);
};


#endif
