// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  FFTScriptingPluginInfo.C
// ************************************************************************* //
#include <PyFFTAttributes.h>
#include <FFTPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(FFT,Scripting)

// ****************************************************************************
// Method: FFTScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
FFTScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyFFTAttributes_StartUp((FFTAttributes *)subj, data);
}

// ****************************************************************************
// Method: FFTScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
FFTScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyFFTAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: FFTScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is FFT plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
FFTScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyFFTAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: FFTScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
FFTScriptingPluginInfo::GetLogString()
{
    std::string s(PyFFTAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: FFTScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
FFTScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyFFTAttributes_SetDefaults((const FFTAttributes *)atts);
}
