// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: FFTPluginInfo.h
// ****************************************************************************

#ifndef FFT_PLUGIN_INFO_H
#define FFT_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class FFTAttributes;

// ****************************************************************************
//  Class: FFTPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an FFT operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class FFTGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class FFTCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual FFTGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class FFTGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual FFTCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class FFTViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual FFTCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static FFTAttributes *defaultAtts;
    static FFTAttributes *clientAtts;
};

class FFTViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual FFTViewerEnginePluginInfo
{
  public:
};

class FFTEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual FFTViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class FFTScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual FFTCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
