// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: FFTAttributes
//
// Purpose:
//    This class contains attributes for the FFT operator.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class FFTAttributes extends AttributeSubject implements Plugin
{
    private static int FFTAttributes_numAdditionalAtts = 1;

    public FFTAttributes()
    {
        super(FFTAttributes_numAdditionalAtts);

        dummy = 0;
    }

    public FFTAttributes(int nMoreFields)
    {
        super(FFTAttributes_numAdditionalAtts + nMoreFields);

        dummy = 0;
    }

    public FFTAttributes(FFTAttributes obj)
    {
        super(obj);

        dummy = obj.dummy;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return FFTAttributes_numAdditionalAtts;
    }

    public boolean equals(FFTAttributes obj)
    {
        // Create the return value
        return ((dummy == obj.dummy));
    }

    public String GetName() { return "FFT"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetDummy(int dummy_)
    {
        dummy = dummy_;
        Select(0);
    }

    // Property getting methods
    public int GetDummy() { return dummy; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(dummy);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        SetDummy(buf.ReadInt());
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + intToString("dummy", dummy, indent) + "\n";
        return str;
    }


    // Attributes
    private int dummy;
}

