// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ExtrudePluginInfo.h
// ****************************************************************************

#ifndef EXTRUDE_PLUGIN_INFO_H
#define EXTRUDE_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class ExtrudeAttributes;

// ****************************************************************************
//  Class: ExtrudePluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Extrude operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class ExtrudeGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class ExtrudeCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual ExtrudeGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class ExtrudeGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual ExtrudeCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class ExtrudeViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual ExtrudeCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static ExtrudeAttributes *defaultAtts;
    static ExtrudeAttributes *clientAtts;
};

class ExtrudeViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual ExtrudeViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class ExtrudeEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual ExtrudeViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class ExtrudeScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual ExtrudeCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
