// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ExtrudeGUIPluginInfo.C
// ****************************************************************************

#include <ExtrudePluginInfo.h>
#include <ExtrudeAttributes.h>
#include <QApplication>
#include <QvisExtrudeWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Extrude,GUI)

// ****************************************************************************
//  Method: ExtrudeGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
ExtrudeGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "Extrude"));
}


// ****************************************************************************
//  Method: ExtrudeGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
ExtrudeGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisExtrudeWindow(type, (ExtrudeAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: ExtrudeGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <Extrude.xpm>
const char **
ExtrudeGUIPluginInfo::XPMIconData() const
{
    return Extrude_xpm;
}

