// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ExtrudeCommonPluginInfo.C
// ****************************************************************************

#include <ExtrudePluginInfo.h>
#include <ExtrudeAttributes.h>

// ****************************************************************************
//  Method: ExtrudeCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ExtrudeCommonPluginInfo::AllocAttributes()
{
    return new ExtrudeAttributes;
}

// ****************************************************************************
//  Method: ExtrudeCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Extrude attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ExtrudeCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((ExtrudeAttributes *) to) = *((ExtrudeAttributes *) from);
}
