// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef EXTRUDEATTRIBUTES_H
#define EXTRUDEATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: ExtrudeAttributes
//
// Purpose:
//    This class contains attributes for the extrude operator.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class ExtrudeAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    ExtrudeAttributes();
    ExtrudeAttributes(const ExtrudeAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    ExtrudeAttributes(private_tmfs_t tmfs);
    ExtrudeAttributes(const ExtrudeAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~ExtrudeAttributes();

    virtual ExtrudeAttributes& operator = (const ExtrudeAttributes &obj);
    virtual bool operator == (const ExtrudeAttributes &obj) const;
    virtual bool operator != (const ExtrudeAttributes &obj) const;
private:
    void Init();
    void Copy(const ExtrudeAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectAxis();
    void SelectVariable();

    // Property setting methods
    void SetAxis(const double *axis_);
    void SetByVariable(bool byVariable_);
    void SetVariable(const std::string &variable_);
    void SetLength(double length_);
    void SetSteps(int steps_);
    void SetPreserveOriginalCellNumbers(bool preserveOriginalCellNumbers_);

    // Property getting methods
    const double      *GetAxis() const;
          double      *GetAxis();
    bool              GetByVariable() const;
    const std::string &GetVariable() const;
          std::string &GetVariable();
    double            GetLength() const;
    int               GetSteps() const;
    bool              GetPreserveOriginalCellNumbers() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_axis = 0,
        ID_byVariable,
        ID_variable,
        ID_length,
        ID_steps,
        ID_preserveOriginalCellNumbers,
        ID__LAST
    };

private:
    double      axis[3];
    bool        byVariable;
    std::string variable;
    double      length;
    int         steps;
    bool        preserveOriginalCellNumbers;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define EXTRUDEATTRIBUTES_TMFS "Dbsdib"

#endif
