// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ExtractPointFunction2DPluginInfo.h
// ****************************************************************************

#ifndef EXTRACTPOINTFUNCTION2D_PLUGIN_INFO_H
#define EXTRACTPOINTFUNCTION2D_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class ExtractPointFunction2DAttributes;

// ****************************************************************************
//  Class: ExtractPointFunction2DPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an ExtractPointFunction2D operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class ExtractPointFunction2DGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class ExtractPointFunction2DCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual ExtractPointFunction2DGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
    virtual ExpressionList *GetCreatedExpressions(const avtDatabaseMetaData *) const;
};

class ExtractPointFunction2DGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual ExtractPointFunction2DCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class ExtractPointFunction2DViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual ExtractPointFunction2DCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static ExtractPointFunction2DAttributes *defaultAtts;
    static ExtractPointFunction2DAttributes *clientAtts;
};

class ExtractPointFunction2DViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual ExtractPointFunction2DViewerEnginePluginInfo
{
  public:
};

class ExtractPointFunction2DEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual ExtractPointFunction2DViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class ExtractPointFunction2DScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual ExtractPointFunction2DCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
