// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ExtractPointFunction2DPluginInfo.C
// ****************************************************************************

#include <ExtractPointFunction2DPluginInfo.h>
#include <ExtractPointFunction2DAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(ExtractPointFunction2D,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(ExtractPointFunction2D,General)

// ****************************************************************************
//  Method: ExtractPointFunction2DGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ExtractPointFunction2DGeneralPluginInfo::GetName() const
{
    return "ExtractPointFunction2D";
}

// ****************************************************************************
//  Method: ExtractPointFunction2DGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ExtractPointFunction2DGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: ExtractPointFunction2DGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ExtractPointFunction2DGeneralPluginInfo::GetID() const
{
    return "ExtractPointFunction2D_1.0";
}
// ****************************************************************************
//  Method: ExtractPointFunction2DGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ExtractPointFunction2DGeneralPluginInfo::EnabledByDefault() const
{
    return false;
}

// ****************************************************************************
//  Method: ExtractPointFunction2DGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ExtractPointFunction2DGeneralPluginInfo::GetCategoryName() const
{
    return "Analysis";
}
