// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ExtractPointFunction2DGUIPluginInfo.C
// ****************************************************************************

#include <ExtractPointFunction2DPluginInfo.h>
#include <ExtractPointFunction2DAttributes.h>
#include <QApplication>
#include <QvisExtractPointFunction2DWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(ExtractPointFunction2D,GUI)

// ****************************************************************************
//  Method: ExtractPointFunction2DGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
ExtractPointFunction2DGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "Extract Point Function 2D"));
}


// ****************************************************************************
//  Method: ExtractPointFunction2DGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
ExtractPointFunction2DGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisExtractPointFunction2DWindow(type, (ExtractPointFunction2DAttributes *)attr,
        caption, shortName, notepad);
}

