// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISEXTERNALSURFACEWINDOW_H
#define QVISEXTERNALSURFACEWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class ExternalSurfaceAttributes;
class QCheckBox;

// ****************************************************************************
// Class: QvisExternalSurfaceWindow
//
// Purpose:
//    Defines QvisExternalSurfaceWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisExternalSurfaceWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisExternalSurfaceWindow(const int type,
                         ExternalSurfaceAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisExternalSurfaceWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void removeGhostsChanged(bool val);
    void edgesIn2DChanged(bool val);
  private:
    QCheckBox *removeGhosts;
    QCheckBox *edgesIn2D;

    ExternalSurfaceAttributes *atts;
};



#endif
