// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  ExternalSurfaceScriptingPluginInfo.C
// ************************************************************************* //
#include <PyExternalSurfaceAttributes.h>
#include <ExternalSurfacePluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(ExternalSurface,Scripting)

// ****************************************************************************
// Method: ExternalSurfaceScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ExternalSurfaceScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyExternalSurfaceAttributes_StartUp((ExternalSurfaceAttributes *)subj, data);
}

// ****************************************************************************
// Method: ExternalSurfaceScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
ExternalSurfaceScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyExternalSurfaceAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ExternalSurfaceScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is ExternalSurface plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ExternalSurfaceScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyExternalSurfaceAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ExternalSurfaceScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
ExternalSurfaceScriptingPluginInfo::GetLogString()
{
    std::string s(PyExternalSurfaceAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: ExternalSurfaceScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ExternalSurfaceScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyExternalSurfaceAttributes_SetDefaults((const ExternalSurfaceAttributes *)atts);
}
