// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISEXPLODEWINDOW_H
#define QVISEXPLODEWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>
#include <MapNode.h>

#include "ExplodeAttributes.h"

class ExplodeAttributes;
class QCheckBox;
class QLineEdit;
class QSpinBox;
class QGridLayout;
class QTabWidget;
class QComboBox;
class QGroupBox;
class QListWidget;
class QPushButton;
class QListWidgetItem;

// ****************************************************************************
// Class: QvisExplodeWindow
//
// Purpose:
//    Defines QvisExplodeWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
//   Alister Maguire, Tue Dec 12 13:13:01 PST 2017
//   Added explosionTabsChangedIndex(), ClearLayout(), 
//   ExplosionType, and materialCheckBoxes. Also 
//   removed boundary names.
//
//   Alister Maguire, Wed Feb 21 11:20:52 PST 2018
//   Added addExplosionToList(), removeExplosionFromList(),
//   clearExplosionList(), switchCurrentExplosion(), updateExplosion(),
//   windowAtts, origAtts, explosionList, addExplosionButton,
//   removeExplosionButton, clearExplosionsButton, 
//   updateExplosionsButton, all for handling multiple explosions. 
//
// ****************************************************************************

class QvisExplodeWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisExplodeWindow(const int type,
                         ExplodeAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisExplodeWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
    void ClearLayout(QLayout *layout);
  private slots:
    void explosionPointProcessText();
    void planePointProcessText();
    void planeNormProcessText();
    void cylinderPoint1ProcessText();
    void cylinderPoint2ProcessText();
    void materialExplosionFactorProcessText();
    void cellExplosionFactorProcessText();
    void materialProcessText();
    void cylinderRadiusProcessText();
    void explosionTabsChangedIndex(int type);
    void explosionPatternChangedIndex(int type);
    void explodeMaterialCellsToggled(bool val);
    void explodeAllCellsToggled(bool val);
    void addExplosionToList();
    void removeExplosionFromList();
    void clearExplosionList();
    void switchCurrentExplosion(QListWidgetItem *);
    void updateExplosion();
  private:
    enum ExplosionTypes
    {
        POINT,
        PLANE, 
        CYLINDER
    };
    enum ExplosionPatterns
    {
        IMPACT,
        SCATTER
    };

    std::string  boundaryString;

    QTabWidget   *explosionTabs;
    QLineEdit    *materialExplosionFactor;
    QLineEdit    *cellExplosionFactor;
    QLineEdit    *explosionPoint;
    QLineEdit    *planePoint;
    QLineEdit    *planeNorm;
    QLineEdit    *cylinderPoint1;
    QLineEdit    *cylinderPoint2;
    QLineEdit    *cylinderRadius;
    QWidget      *materialsWidget;
    QComboBox    *materialsCombo;
    QCheckBox    *explodeMaterialCells;
    QCheckBox    *explodeAllCells;
    QGroupBox    *materialGroup;
    QComboBox    *explosionPattern;
    QListWidget  *explosionList;
    QPushButton  *addExplosionButton;
    QPushButton  *removeExplosionButton;
    QPushButton  *clearExplosionsButton;
    QPushButton  *updateExplosionButton;

    ExplodeAttributes *atts;
    ExplodeAttributes  windowAtts;
    ExplodeAttributes  origAtts;
};

#endif
