// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyExplodeAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <PyExplodeAttributes.h>

// ****************************************************************************
// Module: PyExplodeAttributes
//
// Purpose:
//   This class contains attributes for the explode operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ExplodeAttributes.
//
struct ExplodeAttributesObject
{
    PyObject_HEAD
    ExplodeAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewExplodeAttributes(int);

std::string
PyExplodeAttributes_ToString(const ExplodeAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *explosionType_names = "Point, Plane, Cylinder";
    switch (atts->GetExplosionType())
    {
      case ExplodeAttributes::Point:
          snprintf(tmpStr, 1000, "%sexplosionType = %sPoint  # %s\n", prefix, prefix, explosionType_names);
          str += tmpStr;
          break;
      case ExplodeAttributes::Plane:
          snprintf(tmpStr, 1000, "%sexplosionType = %sPlane  # %s\n", prefix, prefix, explosionType_names);
          str += tmpStr;
          break;
      case ExplodeAttributes::Cylinder:
          snprintf(tmpStr, 1000, "%sexplosionType = %sCylinder  # %s\n", prefix, prefix, explosionType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    {   const double *explosionPoint = atts->GetExplosionPoint();
        snprintf(tmpStr, 1000, "%sexplosionPoint = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", explosionPoint[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *planePoint = atts->GetPlanePoint();
        snprintf(tmpStr, 1000, "%splanePoint = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", planePoint[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *planeNorm = atts->GetPlaneNorm();
        snprintf(tmpStr, 1000, "%splaneNorm = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", planeNorm[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *cylinderPoint1 = atts->GetCylinderPoint1();
        snprintf(tmpStr, 1000, "%scylinderPoint1 = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", cylinderPoint1[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *cylinderPoint2 = atts->GetCylinderPoint2();
        snprintf(tmpStr, 1000, "%scylinderPoint2 = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", cylinderPoint2[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    snprintf(tmpStr, 1000, "%smaterialExplosionFactor = %g\n", prefix, atts->GetMaterialExplosionFactor());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smaterial = \"%s\"\n", prefix, atts->GetMaterial().c_str());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%scylinderRadius = %g\n", prefix, atts->GetCylinderRadius());
    str += tmpStr;
    if(atts->GetExplodeMaterialCells())
        snprintf(tmpStr, 1000, "%sexplodeMaterialCells = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sexplodeMaterialCells = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%scellExplosionFactor = %g\n", prefix, atts->GetCellExplosionFactor());
    str += tmpStr;
    const char *explosionPattern_names = "Impact, Scatter";
    switch (atts->GetExplosionPattern())
    {
      case ExplodeAttributes::Impact:
          snprintf(tmpStr, 1000, "%sexplosionPattern = %sImpact  # %s\n", prefix, prefix, explosionPattern_names);
          str += tmpStr;
          break;
      case ExplodeAttributes::Scatter:
          snprintf(tmpStr, 1000, "%sexplosionPattern = %sScatter  # %s\n", prefix, prefix, explosionPattern_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetExplodeAllCells())
        snprintf(tmpStr, 1000, "%sexplodeAllCells = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sexplodeAllCells = 0\n", prefix);
    str += tmpStr;
    {   const stringVector &boundaryNames = atts->GetBoundaryNames();
        snprintf(tmpStr, 1000, "%sboundaryNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < boundaryNames.size(); ++i)
        {
            snprintf(tmpStr, 1000, "\"%s\"", boundaryNames[i].c_str());
            str += tmpStr;
            if(i < boundaryNames.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    { // new scope
        int index = 0;
        // Create string representation of explosions from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetExplosions().begin(); pos != atts->GetExplosions().end(); ++pos, ++index)
        {
            const ExplodeAttributes *current = (const ExplodeAttributes *)(*pos);
            snprintf(tmpStr, 1000, "GetExplosions(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyExplodeAttributes_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#explosions does not contain any ExplodeAttributes objects.\n";
    }
    return str;
}

static PyObject *
ExplodeAttributes_Notify(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExplodeAttributes_SetExplosionType(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the explosionType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetExplosionType(ExplodeAttributes::ExplodeType(ival));
    else
    {
        fprintf(stderr, "An invalid explosionType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Point, Plane, Cylinder.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExplodeAttributes_GetExplosionType(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetExplosionType()));
    return retval;
}

/*static*/ PyObject *
ExplodeAttributes_SetExplosionPoint(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;

    double *dvals = obj->data->GetExplosionPoint();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the explosionPoint in the object as modified.
    obj->data->SelectExplosionPoint();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExplodeAttributes_GetExplosionPoint(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the explosionPoint.
    PyObject *retval = PyTuple_New(3);
    const double *explosionPoint = obj->data->GetExplosionPoint();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(explosionPoint[i]));
    return retval;
}

/*static*/ PyObject *
ExplodeAttributes_SetPlanePoint(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;

    double *dvals = obj->data->GetPlanePoint();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the planePoint in the object as modified.
    obj->data->SelectPlanePoint();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExplodeAttributes_GetPlanePoint(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the planePoint.
    PyObject *retval = PyTuple_New(3);
    const double *planePoint = obj->data->GetPlanePoint();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(planePoint[i]));
    return retval;
}

/*static*/ PyObject *
ExplodeAttributes_SetPlaneNorm(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;

    double *dvals = obj->data->GetPlaneNorm();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the planeNorm in the object as modified.
    obj->data->SelectPlaneNorm();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExplodeAttributes_GetPlaneNorm(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the planeNorm.
    PyObject *retval = PyTuple_New(3);
    const double *planeNorm = obj->data->GetPlaneNorm();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(planeNorm[i]));
    return retval;
}

/*static*/ PyObject *
ExplodeAttributes_SetCylinderPoint1(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;

    double *dvals = obj->data->GetCylinderPoint1();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the cylinderPoint1 in the object as modified.
    obj->data->SelectCylinderPoint1();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExplodeAttributes_GetCylinderPoint1(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the cylinderPoint1.
    PyObject *retval = PyTuple_New(3);
    const double *cylinderPoint1 = obj->data->GetCylinderPoint1();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(cylinderPoint1[i]));
    return retval;
}

/*static*/ PyObject *
ExplodeAttributes_SetCylinderPoint2(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;

    double *dvals = obj->data->GetCylinderPoint2();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the cylinderPoint2 in the object as modified.
    obj->data->SelectCylinderPoint2();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExplodeAttributes_GetCylinderPoint2(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the cylinderPoint2.
    PyObject *retval = PyTuple_New(3);
    const double *cylinderPoint2 = obj->data->GetCylinderPoint2();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(cylinderPoint2[i]));
    return retval;
}

/*static*/ PyObject *
ExplodeAttributes_SetMaterialExplosionFactor(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the materialExplosionFactor in the object.
    obj->data->SetMaterialExplosionFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExplodeAttributes_GetMaterialExplosionFactor(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaterialExplosionFactor());
    return retval;
}

/*static*/ PyObject *
ExplodeAttributes_SetMaterial(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the material in the object.
    obj->data->SetMaterial(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExplodeAttributes_GetMaterial(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetMaterial().c_str());
    return retval;
}

/*static*/ PyObject *
ExplodeAttributes_SetCylinderRadius(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the cylinderRadius in the object.
    obj->data->SetCylinderRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExplodeAttributes_GetCylinderRadius(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetCylinderRadius());
    return retval;
}

/*static*/ PyObject *
ExplodeAttributes_SetExplodeMaterialCells(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the explodeMaterialCells in the object.
    obj->data->SetExplodeMaterialCells(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExplodeAttributes_GetExplodeMaterialCells(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetExplodeMaterialCells()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ExplodeAttributes_SetCellExplosionFactor(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the cellExplosionFactor in the object.
    obj->data->SetCellExplosionFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExplodeAttributes_GetCellExplosionFactor(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetCellExplosionFactor());
    return retval;
}

/*static*/ PyObject *
ExplodeAttributes_SetExplosionPattern(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the explosionPattern in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetExplosionPattern(ExplodeAttributes::ExplosionPattern(ival));
    else
    {
        fprintf(stderr, "An invalid explosionPattern value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Impact, Scatter.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExplodeAttributes_GetExplosionPattern(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetExplosionPattern()));
    return retval;
}

/*static*/ PyObject *
ExplodeAttributes_SetExplodeAllCells(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the explodeAllCells in the object.
    obj->data->SetExplodeAllCells(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExplodeAttributes_GetExplodeAllCells(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetExplodeAllCells()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ExplodeAttributes_SetBoundaryNames(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;

    stringVector  &vec = obj->data->GetBoundaryNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the boundaryNames in the object as modified.
    obj->data->SelectBoundaryNames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExplodeAttributes_GetBoundaryNames(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the boundaryNames.
    const stringVector &boundaryNames = obj->data->GetBoundaryNames();
    PyObject *retval = PyTuple_New(boundaryNames.size());
    for(size_t i = 0; i < boundaryNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(boundaryNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
ExplodeAttributes_GetExplosions(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || (size_t)index >= obj->data->GetExplosions().size())
    {
        char msg[400] = {'\0'};
        if(obj->data->GetExplosions().size() == 0)
            snprintf(msg, 400, "In ExplodeAttributes::GetExplosions : The index %d is invalid because explosions is empty.", index);
        else
            snprintf(msg, 400, "In ExplodeAttributes::GetExplosions : The index %d is invalid. Use index values in: [0, %ld).",  index, obj->data->GetExplosions().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyExplodeAttributes_Wrap(&obj->data->GetExplosions(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyExplodeAttributes_SetParent(retval, self);

    return retval;
}

PyObject *
ExplodeAttributes_GetNumExplosions(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    return PyInt_FromLong((long)obj->data->GetExplosions().size());
}

PyObject *
ExplodeAttributes_AddExplosions(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyExplodeAttributes_Check(element))
    {
        char msg[400] = {'\0'};
        snprintf(msg, 400, "The ExplodeAttributes::AddExplosions method only accepts ExplodeAttributes objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    ExplodeAttributes *newData = PyExplodeAttributes_FromPyObject(element);
    obj->data->AddExplosions(*newData);
    obj->data->SelectExplosions();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ExplodeAttributes_Remove_One_Explosions(PyObject *self, int index)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveExplosions() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetExplosions();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times.
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectExplosions();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
ExplodeAttributes_RemoveExplosions(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    if(index < 0 || index >= obj->data->GetNumExplosions())
    {
        char msg[400] = {'\0'};
        snprintf(msg, 400, "In ExplodeAttributes::RemoveExplosions : Index %d is out of range", index);
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    return ExplodeAttributes_Remove_One_Explosions(self, index);
}

PyObject *
ExplodeAttributes_ClearExplosions(PyObject *self, PyObject *args)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)self;
    int n = obj->data->GetNumExplosions();
    for(int i = 0; i < n; ++i)
    {
        ExplodeAttributes_Remove_One_Explosions(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}



PyMethodDef PyExplodeAttributes_methods[EXPLODEATTRIBUTES_NMETH] = {
    {"Notify", ExplodeAttributes_Notify, METH_VARARGS},
    {"SetExplosionType", ExplodeAttributes_SetExplosionType, METH_VARARGS},
    {"GetExplosionType", ExplodeAttributes_GetExplosionType, METH_VARARGS},
    {"SetExplosionPoint", ExplodeAttributes_SetExplosionPoint, METH_VARARGS},
    {"GetExplosionPoint", ExplodeAttributes_GetExplosionPoint, METH_VARARGS},
    {"SetPlanePoint", ExplodeAttributes_SetPlanePoint, METH_VARARGS},
    {"GetPlanePoint", ExplodeAttributes_GetPlanePoint, METH_VARARGS},
    {"SetPlaneNorm", ExplodeAttributes_SetPlaneNorm, METH_VARARGS},
    {"GetPlaneNorm", ExplodeAttributes_GetPlaneNorm, METH_VARARGS},
    {"SetCylinderPoint1", ExplodeAttributes_SetCylinderPoint1, METH_VARARGS},
    {"GetCylinderPoint1", ExplodeAttributes_GetCylinderPoint1, METH_VARARGS},
    {"SetCylinderPoint2", ExplodeAttributes_SetCylinderPoint2, METH_VARARGS},
    {"GetCylinderPoint2", ExplodeAttributes_GetCylinderPoint2, METH_VARARGS},
    {"SetMaterialExplosionFactor", ExplodeAttributes_SetMaterialExplosionFactor, METH_VARARGS},
    {"GetMaterialExplosionFactor", ExplodeAttributes_GetMaterialExplosionFactor, METH_VARARGS},
    {"SetMaterial", ExplodeAttributes_SetMaterial, METH_VARARGS},
    {"GetMaterial", ExplodeAttributes_GetMaterial, METH_VARARGS},
    {"SetCylinderRadius", ExplodeAttributes_SetCylinderRadius, METH_VARARGS},
    {"GetCylinderRadius", ExplodeAttributes_GetCylinderRadius, METH_VARARGS},
    {"SetExplodeMaterialCells", ExplodeAttributes_SetExplodeMaterialCells, METH_VARARGS},
    {"GetExplodeMaterialCells", ExplodeAttributes_GetExplodeMaterialCells, METH_VARARGS},
    {"SetCellExplosionFactor", ExplodeAttributes_SetCellExplosionFactor, METH_VARARGS},
    {"GetCellExplosionFactor", ExplodeAttributes_GetCellExplosionFactor, METH_VARARGS},
    {"SetExplosionPattern", ExplodeAttributes_SetExplosionPattern, METH_VARARGS},
    {"GetExplosionPattern", ExplodeAttributes_GetExplosionPattern, METH_VARARGS},
    {"SetExplodeAllCells", ExplodeAttributes_SetExplodeAllCells, METH_VARARGS},
    {"GetExplodeAllCells", ExplodeAttributes_GetExplodeAllCells, METH_VARARGS},
    {"SetBoundaryNames", ExplodeAttributes_SetBoundaryNames, METH_VARARGS},
    {"GetBoundaryNames", ExplodeAttributes_GetBoundaryNames, METH_VARARGS},
    {"GetExplosions", ExplodeAttributes_GetExplosions, METH_VARARGS},
    {"GetNumExplosions", ExplodeAttributes_GetNumExplosions, METH_VARARGS},
    {"AddExplosions", ExplodeAttributes_AddExplosions, METH_VARARGS},
    {"RemoveExplosions", ExplodeAttributes_RemoveExplosions, METH_VARARGS},
    {"ClearExplosions", ExplodeAttributes_ClearExplosions, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ExplodeAttributes_dealloc(PyObject *v)
{
   ExplodeAttributesObject *obj = (ExplodeAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ExplodeAttributes_compare(PyObject *v, PyObject *w)
{
    ExplodeAttributes *a = ((ExplodeAttributesObject *)v)->data;
    ExplodeAttributes *b = ((ExplodeAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyExplodeAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "explosionType") == 0)
        return ExplodeAttributes_GetExplosionType(self, NULL);
    if(strcmp(name, "Point") == 0)
        return PyInt_FromLong(long(ExplodeAttributes::Point));
    if(strcmp(name, "Plane") == 0)
        return PyInt_FromLong(long(ExplodeAttributes::Plane));
    if(strcmp(name, "Cylinder") == 0)
        return PyInt_FromLong(long(ExplodeAttributes::Cylinder));

    if(strcmp(name, "explosionPoint") == 0)
        return ExplodeAttributes_GetExplosionPoint(self, NULL);
    if(strcmp(name, "planePoint") == 0)
        return ExplodeAttributes_GetPlanePoint(self, NULL);
    if(strcmp(name, "planeNorm") == 0)
        return ExplodeAttributes_GetPlaneNorm(self, NULL);
    if(strcmp(name, "cylinderPoint1") == 0)
        return ExplodeAttributes_GetCylinderPoint1(self, NULL);
    if(strcmp(name, "cylinderPoint2") == 0)
        return ExplodeAttributes_GetCylinderPoint2(self, NULL);
    if(strcmp(name, "materialExplosionFactor") == 0)
        return ExplodeAttributes_GetMaterialExplosionFactor(self, NULL);
    if(strcmp(name, "material") == 0)
        return ExplodeAttributes_GetMaterial(self, NULL);
    if(strcmp(name, "cylinderRadius") == 0)
        return ExplodeAttributes_GetCylinderRadius(self, NULL);
    if(strcmp(name, "explodeMaterialCells") == 0)
        return ExplodeAttributes_GetExplodeMaterialCells(self, NULL);
    if(strcmp(name, "cellExplosionFactor") == 0)
        return ExplodeAttributes_GetCellExplosionFactor(self, NULL);
    if(strcmp(name, "explosionPattern") == 0)
        return ExplodeAttributes_GetExplosionPattern(self, NULL);
    if(strcmp(name, "Impact") == 0)
        return PyInt_FromLong(long(ExplodeAttributes::Impact));
    if(strcmp(name, "Scatter") == 0)
        return PyInt_FromLong(long(ExplodeAttributes::Scatter));

    if(strcmp(name, "explodeAllCells") == 0)
        return ExplodeAttributes_GetExplodeAllCells(self, NULL);
    if(strcmp(name, "boundaryNames") == 0)
        return ExplodeAttributes_GetBoundaryNames(self, NULL);
    if(strcmp(name, "explosions") == 0)
        return ExplodeAttributes_GetExplosions(self, NULL);

    return Py_FindMethod(PyExplodeAttributes_methods, self, name);
}

int
PyExplodeAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "explosionType") == 0)
        obj = ExplodeAttributes_SetExplosionType(self, tuple);
    else if(strcmp(name, "explosionPoint") == 0)
        obj = ExplodeAttributes_SetExplosionPoint(self, tuple);
    else if(strcmp(name, "planePoint") == 0)
        obj = ExplodeAttributes_SetPlanePoint(self, tuple);
    else if(strcmp(name, "planeNorm") == 0)
        obj = ExplodeAttributes_SetPlaneNorm(self, tuple);
    else if(strcmp(name, "cylinderPoint1") == 0)
        obj = ExplodeAttributes_SetCylinderPoint1(self, tuple);
    else if(strcmp(name, "cylinderPoint2") == 0)
        obj = ExplodeAttributes_SetCylinderPoint2(self, tuple);
    else if(strcmp(name, "materialExplosionFactor") == 0)
        obj = ExplodeAttributes_SetMaterialExplosionFactor(self, tuple);
    else if(strcmp(name, "material") == 0)
        obj = ExplodeAttributes_SetMaterial(self, tuple);
    else if(strcmp(name, "cylinderRadius") == 0)
        obj = ExplodeAttributes_SetCylinderRadius(self, tuple);
    else if(strcmp(name, "explodeMaterialCells") == 0)
        obj = ExplodeAttributes_SetExplodeMaterialCells(self, tuple);
    else if(strcmp(name, "cellExplosionFactor") == 0)
        obj = ExplodeAttributes_SetCellExplosionFactor(self, tuple);
    else if(strcmp(name, "explosionPattern") == 0)
        obj = ExplodeAttributes_SetExplosionPattern(self, tuple);
    else if(strcmp(name, "explodeAllCells") == 0)
        obj = ExplodeAttributes_SetExplodeAllCells(self, tuple);
    else if(strcmp(name, "boundaryNames") == 0)
        obj = ExplodeAttributes_SetBoundaryNames(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ExplodeAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)v;
    fprintf(fp, "%s", PyExplodeAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ExplodeAttributes_str(PyObject *v)
{
    ExplodeAttributesObject *obj = (ExplodeAttributesObject *)v;
    return PyString_FromString(PyExplodeAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ExplodeAttributes_Purpose = "This class contains attributes for the explode operator.";
#else
static char *ExplodeAttributes_Purpose = "This class contains attributes for the explode operator.";
#endif

//
// The type description structure
//
static PyTypeObject ExplodeAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ExplodeAttributes",                    // tp_name
    sizeof(ExplodeAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ExplodeAttributes_dealloc,  // tp_dealloc
    (printfunc)ExplodeAttributes_print,     // tp_print
    (getattrfunc)PyExplodeAttributes_getattr, // tp_getattr
    (setattrfunc)PyExplodeAttributes_setattr, // tp_setattr
    (cmpfunc)ExplodeAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ExplodeAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ExplodeAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ExplodeAttributes *defaultAtts = 0;
static ExplodeAttributes *currentAtts = 0;

static PyObject *
NewExplodeAttributes(int useCurrent)
{
    ExplodeAttributesObject *newObject;
    newObject = PyObject_NEW(ExplodeAttributesObject, &ExplodeAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ExplodeAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ExplodeAttributes(*defaultAtts);
    else
        newObject->data = new ExplodeAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapExplodeAttributes(const ExplodeAttributes *attr)
{
    ExplodeAttributesObject *newObject;
    newObject = PyObject_NEW(ExplodeAttributesObject, &ExplodeAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ExplodeAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ExplodeAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewExplodeAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ExplodeAttributesMethods[] = {
    {"ExplodeAttributes", ExplodeAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ExplodeAttributesObserver = 0;

std::string
PyExplodeAttributes_GetLogString()
{
    std::string s("ExplodeAtts = ExplodeAttributes()\n");
    if(currentAtts != 0)
        s += PyExplodeAttributes_ToString(currentAtts, "ExplodeAtts.");
    return s;
}

static void
PyExplodeAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ExplodeAtts = ExplodeAttributes()\n");
        s += PyExplodeAttributes_ToString(currentAtts, "ExplodeAtts.");
        cb(s);
    }
}

void
PyExplodeAttributes_StartUp(ExplodeAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyExplodeAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ExplodeAttributesObserver == 0)
    {
        ExplodeAttributesObserver = new ObserverToCallback(subj,
            PyExplodeAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyExplodeAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ExplodeAttributesObserver;
    ExplodeAttributesObserver = 0;
}

PyMethodDef *
PyExplodeAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ExplodeAttributesMethods;
}

bool
PyExplodeAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ExplodeAttributesType);
}

ExplodeAttributes *
PyExplodeAttributes_FromPyObject(PyObject *obj)
{
    ExplodeAttributesObject *obj2 = (ExplodeAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyExplodeAttributes_New()
{
    return NewExplodeAttributes(0);
}

PyObject *
PyExplodeAttributes_Wrap(const ExplodeAttributes *attr)
{
    return WrapExplodeAttributes(attr);
}

void
PyExplodeAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ExplodeAttributesObject *obj2 = (ExplodeAttributesObject *)obj;
    obj2->parent = parent;
}

//****************************************************************************
//  Modifications:
//    Alister Maguire, Wed Jan 10 11:29:50 PST 2018
//    Make defaultAtts point to the passed atts directly.
//
//****************************************************************************
void
PyExplodeAttributes_SetDefaults(const ExplodeAttributes *atts)
{
    defaultAtts = const_cast<ExplodeAttributes*>(atts);
}

