// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISELLIPSOIDSLICEWINDOW_H
#define QVISELLIPSOIDSLICEWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class EllipsoidSliceAttributes;
class QLabel;
class QLineEdit;

// ****************************************************************************
// Class: QvisEllipsoidSliceWindow
//
// Purpose:
//    Defines QvisEllipsoidSliceWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisEllipsoidSliceWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisEllipsoidSliceWindow(const int type,
                         EllipsoidSliceAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisEllipsoidSliceWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void originProcessText();
    void radiiProcessText();
    void rotationAngleProcessText();
  private:
    QLineEdit *origin;
    QLineEdit *radii;
    QLineEdit *rotationAngle;
    QLabel *originLabel;
    QLabel *radiiLabel;
    QLabel *rotationAngleLabel;

    EllipsoidSliceAttributes *atts;
};



#endif
