// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyEllipsoidSliceAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyEllipsoidSliceAttributes
//
// Purpose:
//   EllipsoidSliceAttributes
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a EllipsoidSliceAttributes.
//
struct EllipsoidSliceAttributesObject
{
    PyObject_HEAD
    EllipsoidSliceAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewEllipsoidSliceAttributes(int);

std::string
PyEllipsoidSliceAttributes_ToString(const EllipsoidSliceAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const double *origin = atts->GetOrigin();
        snprintf(tmpStr, 1000, "%sorigin = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", origin[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *radii = atts->GetRadii();
        snprintf(tmpStr, 1000, "%sradii = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", radii[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *rotationAngle = atts->GetRotationAngle();
        snprintf(tmpStr, 1000, "%srotationAngle = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", rotationAngle[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
EllipsoidSliceAttributes_Notify(PyObject *self, PyObject *args)
{
    EllipsoidSliceAttributesObject *obj = (EllipsoidSliceAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
EllipsoidSliceAttributes_SetOrigin(PyObject *self, PyObject *args)
{
    EllipsoidSliceAttributesObject *obj = (EllipsoidSliceAttributesObject *)self;

    double *dvals = obj->data->GetOrigin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the origin in the object as modified.
    obj->data->SelectOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
EllipsoidSliceAttributes_GetOrigin(PyObject *self, PyObject *args)
{
    EllipsoidSliceAttributesObject *obj = (EllipsoidSliceAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the origin.
    PyObject *retval = PyTuple_New(3);
    const double *origin = obj->data->GetOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(origin[i]));
    return retval;
}

/*static*/ PyObject *
EllipsoidSliceAttributes_SetRadii(PyObject *self, PyObject *args)
{
    EllipsoidSliceAttributesObject *obj = (EllipsoidSliceAttributesObject *)self;

    double *dvals = obj->data->GetRadii();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the radii in the object as modified.
    obj->data->SelectRadii();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
EllipsoidSliceAttributes_GetRadii(PyObject *self, PyObject *args)
{
    EllipsoidSliceAttributesObject *obj = (EllipsoidSliceAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the radii.
    PyObject *retval = PyTuple_New(3);
    const double *radii = obj->data->GetRadii();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(radii[i]));
    return retval;
}

/*static*/ PyObject *
EllipsoidSliceAttributes_SetRotationAngle(PyObject *self, PyObject *args)
{
    EllipsoidSliceAttributesObject *obj = (EllipsoidSliceAttributesObject *)self;

    double *dvals = obj->data->GetRotationAngle();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the rotationAngle in the object as modified.
    obj->data->SelectRotationAngle();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
EllipsoidSliceAttributes_GetRotationAngle(PyObject *self, PyObject *args)
{
    EllipsoidSliceAttributesObject *obj = (EllipsoidSliceAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the rotationAngle.
    PyObject *retval = PyTuple_New(3);
    const double *rotationAngle = obj->data->GetRotationAngle();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(rotationAngle[i]));
    return retval;
}



PyMethodDef PyEllipsoidSliceAttributes_methods[ELLIPSOIDSLICEATTRIBUTES_NMETH] = {
    {"Notify", EllipsoidSliceAttributes_Notify, METH_VARARGS},
    {"SetOrigin", EllipsoidSliceAttributes_SetOrigin, METH_VARARGS},
    {"GetOrigin", EllipsoidSliceAttributes_GetOrigin, METH_VARARGS},
    {"SetRadii", EllipsoidSliceAttributes_SetRadii, METH_VARARGS},
    {"GetRadii", EllipsoidSliceAttributes_GetRadii, METH_VARARGS},
    {"SetRotationAngle", EllipsoidSliceAttributes_SetRotationAngle, METH_VARARGS},
    {"GetRotationAngle", EllipsoidSliceAttributes_GetRotationAngle, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
EllipsoidSliceAttributes_dealloc(PyObject *v)
{
   EllipsoidSliceAttributesObject *obj = (EllipsoidSliceAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
EllipsoidSliceAttributes_compare(PyObject *v, PyObject *w)
{
    EllipsoidSliceAttributes *a = ((EllipsoidSliceAttributesObject *)v)->data;
    EllipsoidSliceAttributes *b = ((EllipsoidSliceAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyEllipsoidSliceAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "origin") == 0)
        return EllipsoidSliceAttributes_GetOrigin(self, NULL);
    if(strcmp(name, "radii") == 0)
        return EllipsoidSliceAttributes_GetRadii(self, NULL);
    if(strcmp(name, "rotationAngle") == 0)
        return EllipsoidSliceAttributes_GetRotationAngle(self, NULL);

    return Py_FindMethod(PyEllipsoidSliceAttributes_methods, self, name);
}

int
PyEllipsoidSliceAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "origin") == 0)
        obj = EllipsoidSliceAttributes_SetOrigin(self, tuple);
    else if(strcmp(name, "radii") == 0)
        obj = EllipsoidSliceAttributes_SetRadii(self, tuple);
    else if(strcmp(name, "rotationAngle") == 0)
        obj = EllipsoidSliceAttributes_SetRotationAngle(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
EllipsoidSliceAttributes_print(PyObject *v, FILE *fp, int flags)
{
    EllipsoidSliceAttributesObject *obj = (EllipsoidSliceAttributesObject *)v;
    fprintf(fp, "%s", PyEllipsoidSliceAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
EllipsoidSliceAttributes_str(PyObject *v)
{
    EllipsoidSliceAttributesObject *obj = (EllipsoidSliceAttributesObject *)v;
    return PyString_FromString(PyEllipsoidSliceAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *EllipsoidSliceAttributes_Purpose = "EllipsoidSliceAttributes";
#else
static char *EllipsoidSliceAttributes_Purpose = "EllipsoidSliceAttributes";
#endif

//
// The type description structure
//
static PyTypeObject EllipsoidSliceAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "EllipsoidSliceAttributes",                    // tp_name
    sizeof(EllipsoidSliceAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)EllipsoidSliceAttributes_dealloc,  // tp_dealloc
    (printfunc)EllipsoidSliceAttributes_print,     // tp_print
    (getattrfunc)PyEllipsoidSliceAttributes_getattr, // tp_getattr
    (setattrfunc)PyEllipsoidSliceAttributes_setattr, // tp_setattr
    (cmpfunc)EllipsoidSliceAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)EllipsoidSliceAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    EllipsoidSliceAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static EllipsoidSliceAttributes *defaultAtts = 0;
static EllipsoidSliceAttributes *currentAtts = 0;

static PyObject *
NewEllipsoidSliceAttributes(int useCurrent)
{
    EllipsoidSliceAttributesObject *newObject;
    newObject = PyObject_NEW(EllipsoidSliceAttributesObject, &EllipsoidSliceAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new EllipsoidSliceAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new EllipsoidSliceAttributes(*defaultAtts);
    else
        newObject->data = new EllipsoidSliceAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapEllipsoidSliceAttributes(const EllipsoidSliceAttributes *attr)
{
    EllipsoidSliceAttributesObject *newObject;
    newObject = PyObject_NEW(EllipsoidSliceAttributesObject, &EllipsoidSliceAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (EllipsoidSliceAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
EllipsoidSliceAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewEllipsoidSliceAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef EllipsoidSliceAttributesMethods[] = {
    {"EllipsoidSliceAttributes", EllipsoidSliceAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *EllipsoidSliceAttributesObserver = 0;

std::string
PyEllipsoidSliceAttributes_GetLogString()
{
    std::string s("EllipsoidSliceAtts = EllipsoidSliceAttributes()\n");
    if(currentAtts != 0)
        s += PyEllipsoidSliceAttributes_ToString(currentAtts, "EllipsoidSliceAtts.");
    return s;
}

static void
PyEllipsoidSliceAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("EllipsoidSliceAtts = EllipsoidSliceAttributes()\n");
        s += PyEllipsoidSliceAttributes_ToString(currentAtts, "EllipsoidSliceAtts.");
        cb(s);
    }
}

void
PyEllipsoidSliceAttributes_StartUp(EllipsoidSliceAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyEllipsoidSliceAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(EllipsoidSliceAttributesObserver == 0)
    {
        EllipsoidSliceAttributesObserver = new ObserverToCallback(subj,
            PyEllipsoidSliceAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyEllipsoidSliceAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete EllipsoidSliceAttributesObserver;
    EllipsoidSliceAttributesObserver = 0;
}

PyMethodDef *
PyEllipsoidSliceAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return EllipsoidSliceAttributesMethods;
}

bool
PyEllipsoidSliceAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &EllipsoidSliceAttributesType);
}

EllipsoidSliceAttributes *
PyEllipsoidSliceAttributes_FromPyObject(PyObject *obj)
{
    EllipsoidSliceAttributesObject *obj2 = (EllipsoidSliceAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyEllipsoidSliceAttributes_New()
{
    return NewEllipsoidSliceAttributes(0);
}

PyObject *
PyEllipsoidSliceAttributes_Wrap(const EllipsoidSliceAttributes *attr)
{
    return WrapEllipsoidSliceAttributes(attr);
}

void
PyEllipsoidSliceAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    EllipsoidSliceAttributesObject *obj2 = (EllipsoidSliceAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyEllipsoidSliceAttributes_SetDefaults(const EllipsoidSliceAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new EllipsoidSliceAttributes(*atts);
}

