// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: EllipsoidSliceViewerEnginePluginInfo.C
// ****************************************************************************

#include <EllipsoidSlicePluginInfo.h>
#include <EllipsoidSliceAttributes.h>

//
// Storage for static data elements.
//
EllipsoidSliceAttributes *EllipsoidSliceViewerEnginePluginInfo::clientAtts = NULL;
EllipsoidSliceAttributes *EllipsoidSliceViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  EllipsoidSliceViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
EllipsoidSliceViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (EllipsoidSliceViewerEnginePluginInfo::clientAtts == NULL)
    {
        EllipsoidSliceViewerEnginePluginInfo::clientAtts  = new EllipsoidSliceAttributes;
        EllipsoidSliceViewerEnginePluginInfo::defaultAtts = new EllipsoidSliceAttributes;
    }
}

// ****************************************************************************
//  Method: EllipsoidSliceViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
EllipsoidSliceViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: EllipsoidSliceViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
EllipsoidSliceViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: EllipsoidSliceViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
EllipsoidSliceViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(EllipsoidSliceAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: EllipsoidSliceViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
EllipsoidSliceViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(EllipsoidSliceAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: EllipsoidSliceViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
EllipsoidSliceViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(EllipsoidSliceAttributes*)atts = *defaultAtts;
    else
        *(EllipsoidSliceAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: EllipsoidSliceViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
EllipsoidSliceViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: EllipsoidSliceViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
EllipsoidSliceViewerEnginePluginInfo::GetMenuName() const
{
    return "EllipsoidSlice";
}

