// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  EllipsoidSliceScriptingPluginInfo.C
// ************************************************************************* //
#include <PyEllipsoidSliceAttributes.h>
#include <EllipsoidSlicePluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(EllipsoidSlice,Scripting)

// ****************************************************************************
// Method: EllipsoidSliceScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
EllipsoidSliceScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyEllipsoidSliceAttributes_StartUp((EllipsoidSliceAttributes *)subj, data);
}

// ****************************************************************************
// Method: EllipsoidSliceScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
EllipsoidSliceScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyEllipsoidSliceAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: EllipsoidSliceScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is EllipsoidSlice plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
EllipsoidSliceScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyEllipsoidSliceAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: EllipsoidSliceScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
EllipsoidSliceScriptingPluginInfo::GetLogString()
{
    std::string s(PyEllipsoidSliceAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: EllipsoidSliceScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
EllipsoidSliceScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyEllipsoidSliceAttributes_SetDefaults((const EllipsoidSliceAttributes *)atts);
}
