// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: EllipsoidSlicePluginInfo.h
// ****************************************************************************

#ifndef ELLIPSOIDSLICE_PLUGIN_INFO_H
#define ELLIPSOIDSLICE_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class EllipsoidSliceAttributes;

// ****************************************************************************
//  Class: EllipsoidSlicePluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an EllipsoidSlice operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class EllipsoidSliceGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class EllipsoidSliceCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual EllipsoidSliceGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class EllipsoidSliceGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual EllipsoidSliceCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class EllipsoidSliceViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual EllipsoidSliceCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static EllipsoidSliceAttributes *defaultAtts;
    static EllipsoidSliceAttributes *clientAtts;
};

class EllipsoidSliceViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual EllipsoidSliceViewerEnginePluginInfo
{
  public:
};

class EllipsoidSliceEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual EllipsoidSliceViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class EllipsoidSliceScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual EllipsoidSliceCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
